/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.permission.PermissionRevocationRequestedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.CancelState;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@TransactionAware(value=TransactionAware.When.IMMEDIATE)
public class RepositoryPermissionRevocationRequestedEvent
extends RepositoryPermissionEvent
implements PermissionRevocationRequestedEvent {
    private final CancelState cancelState;

    public RepositoryPermissionRevocationRequestedEvent(@Nonnull Object source, @Nonnull Permission permission, @Nonnull Repository repository, @Nullable String affectedGroup, @Nullable ApplicationUser affectedUser, @Nonnull CancelState cancelState) {
        super(source, permission, repository, affectedGroup, affectedUser);
        this.cancelState = (CancelState)Preconditions.checkNotNull((Object)cancelState, (Object)"cancelState");
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

