/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.scm.AbstractCommitCommandParameters;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class CommitCommandParameters
extends AbstractCommitCommandParameters {
    private static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final int maxMessageLength;

    private CommitCommandParameters(Builder builder) {
        super(builder);
        if (StringUtils.isBlank((CharSequence)this.getCommitId())) {
            throw new IllegalStateException("A commit ID is required to retrieve a commit");
        }
        this.maxMessageLength = builder.maxMessageLength;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public static class Builder
    extends AbstractCommitCommandParameters.AbstractCommitParametersBuilder<Builder> {
        private int maxMessageLength;

        public Builder() {
            this.maxMessageLength = -1;
        }

        public Builder(@Nonnull CommitRequest request) {
            super(request);
            this.maxMessageLength(request.getMaxMessageLength());
        }

        @Nonnull
        public CommitCommandParameters build() {
            return new CommitCommandParameters(this);
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

