/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.repository.Repository;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestParticipantSearchRequest {
    private final Optional<String> filter;
    private final Optional<Repository> fromRepository;
    private final Optional<PullRequestRole> role;
    private final Optional<Repository> toRepository;

    private PullRequestParticipantSearchRequest(Builder builder) {
        this.fromRepository = builder.fromRepository;
        this.role = builder.role;
        this.filter = builder.filter;
        this.toRepository = builder.toRepository;
    }

    @Nonnull
    public Optional<String> getFilter() {
        return this.filter;
    }

    @Nonnull
    public Optional<Repository> getFromRepository() {
        return this.fromRepository;
    }

    @Nonnull
    public Optional<PullRequestRole> getRole() {
        return this.role;
    }

    @Nonnull
    public Optional<Repository> getToRepository() {
        return this.toRepository;
    }

    public static class Builder {
        private Optional<String> filter = Optional.empty();
        private Optional<Repository> fromRepository = Optional.empty();
        private Optional<PullRequestRole> role = Optional.empty();
        private Optional<Repository> toRepository = Optional.empty();

        @Nonnull
        public PullRequestParticipantSearchRequest build() {
            return new PullRequestParticipantSearchRequest(this);
        }

        @Nonnull
        public Builder filter(@Nullable String value) {
            this.filter = Optional.ofNullable(value);
            return this;
        }

        @Nonnull
        public Builder fromRepository(@Nullable Repository value) {
            this.fromRepository = Optional.ofNullable(value);
            return this;
        }

        @Nonnull
        public Builder role(@Nullable PullRequestRole value) {
            this.role = Optional.ofNullable(value);
            return this;
        }

        @Nonnull
        public Builder toRepository(@Nullable Repository value) {
            this.toRepository = Optional.ofNullable(value);
            return this;
        }
    }
}

