/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

public class CommitsBetweenRequest {
    private static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final Set<String> excludes;
    private final boolean followRenames;
    private final Boolean ignoringMissing;
    private final Set<String> includes;
    private final int maxMessageLength;
    private final Set<String> paths;
    private final Set<String> propertyKeys;
    private final Repository repository;
    private final Repository secondaryRepository;

    private CommitsBetweenRequest(Builder builder) {
        this.excludes = builder.excludes.build();
        this.followRenames = builder.followRenames;
        this.ignoringMissing = builder.ignoringMissing;
        this.includes = builder.includes.build();
        this.maxMessageLength = builder.maxMessageLength;
        this.paths = builder.paths.build();
        this.propertyKeys = builder.propertyKeys.build();
        this.repository = builder.repository;
        this.secondaryRepository = builder.secondaryRepository;
        if (this.includes.isEmpty()) {
            throw new IllegalStateException("At least one commit must be provided to include");
        }
        if (this.followRenames) {
            if (this.paths.isEmpty()) {
                throw new IllegalStateException("A path must be supplied when attempting to follow renames");
            }
            if (this.paths.size() > 1) {
                throw new IllegalStateException("Following renames is only possible with a single path");
            }
        }
    }

    @Nonnull
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Nonnull
    public Set<String> getIncludes() {
        return this.includes;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.propertyKeys;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    public boolean isFollowingRenames() {
        return this.followRenames;
    }

    @Nullable
    @Deprecated
    public Boolean isIgnoringMissing() {
        return this.ignoringMissing;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> excludes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> includes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> propertyKeys = ImmutableSet.builder();
        private final Repository repository;
        private boolean followRenames;
        private Boolean ignoringMissing;
        private int maxMessageLength = -1;
        private Repository secondaryRepository;

        public Builder(@Nonnull Repository repository) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        }

        public Builder(@Nonnull CommitsBetweenRequest request) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)((CommitsBetweenRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getRepository(), (Object)"request.repository");
            this.exclude(request.getExcludes()).followRenames(request.isFollowingRenames()).ignoreMissing(request.isIgnoringMissing()).include(request.getIncludes()).maxMessageLength(request.getMaxMessageLength()).paths(request.getPaths()).propertyKeys(request.getPropertyKeys()).secondaryRepository(request.getSecondaryRepository());
        }

        public Builder(@Nonnull PullRequest pullRequest) {
            Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
            PullRequestRef fromRef = (PullRequestRef)Preconditions.checkNotNull((Object)pullRequest.getFromRef(), (Object)"pullRequest.fromRef");
            PullRequestRef toRef = (PullRequestRef)Preconditions.checkNotNull((Object)pullRequest.getToRef(), (Object)"pullRequest.toRef");
            this.repository = (Repository)Preconditions.checkNotNull((Object)toRef.getRepository(), (Object)"pullRequest.toRef.repository");
            this.exclude((String)Preconditions.checkNotNull((Object)toRef.getLatestCommit(), (Object)"pullRequest.toRef.latestCommit"), new String[0]).include((String)Preconditions.checkNotNull((Object)fromRef.getLatestCommit(), (Object)"pullRequest.fromRef.latestCommit"), new String[0]);
            if (pullRequest.isCrossRepository()) {
                this.secondaryRepository((Repository)Preconditions.checkNotNull((Object)fromRef.getRepository(), (Object)"pullRequest.fromRef.repository"));
            }
        }

        @Nonnull
        public CommitsBetweenRequest build() {
            return new CommitsBetweenRequest(this);
        }

        @Nonnull
        public Builder exclude(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.excludes, value, values);
            return this;
        }

        @Nonnull
        public Builder exclude(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.excludes, values);
            return this;
        }

        @Nonnull
        public Builder followRenames(boolean value) {
            this.followRenames = value;
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoringMissing = value;
            return this;
        }

        @Nonnull
        public Builder include(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.includes, value, values);
            return this;
        }

        @Nonnull
        public Builder include(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.includes, values);
            return this;
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        @Nonnull
        public Builder propertyKey(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value);
            return this;
        }

        @Nonnull
        public Builder propertyKeys(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, values);
            return this;
        }

        @Nonnull
        public Builder propertyKeys(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value, values);
            return this;
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            if (value != null && ObjectUtils.notEqual((Object)this.repository.getHierarchyId(), (Object)value.getHierarchyId())) {
                throw new IllegalStateException("Repository " + value.getProject().getKey() + "/" + value.getSlug() + " is not from the same hierarchy as " + this.repository.getProject().getKey() + "/" + this.repository.getSlug() + "; only repositories from the same hierarchy may be compared.");
            }
            this.secondaryRepository = value;
            return this;
        }
    }
}

