/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.ref;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AbstractRefCommandParameters
extends AbstractCommandParameters {
    private final ApplicationUser author;
    private final String message;
    private final String name;

    protected AbstractRefCommandParameters(AbstractRefBuilder builder) {
        this.author = builder.author;
        this.message = builder.message;
        this.name = builder.name;
    }

    @Nullable
    public ApplicationUser getAuthor() {
        return this.author;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public static abstract class AbstractRefBuilder<B extends AbstractRefBuilder<B>> {
        private ApplicationUser author;
        private String message;
        private String name;

        @Nonnull
        public B author(@Nonnull ApplicationUser value) {
            this.author = (ApplicationUser)Preconditions.checkNotNull((Object)value, (Object)"author");
            return this.self();
        }

        @Nonnull
        public B message(@Nonnull String value) {
            this.message = (String)Preconditions.checkNotNull((Object)value, (Object)"message");
            return this.self();
        }

        @Nonnull
        public B name(@Nonnull String value) {
            this.name = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
            return this.self();
        }

        @Nonnull
        protected abstract B self();

        protected void validate() {
            if (StringUtils.isBlank((CharSequence)this.name)) {
                throw new IllegalStateException("When working with refs a name is required.");
            }
        }
    }
}

