/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration.web;

import com.atlassian.bitbucket.internal.hipchat.notification.configuration.NotificationConfigurationContextBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HipChatRepoSettingsServlet
extends HttpServlet {
    private static final String PROJECTS = "projects";
    private static final String REPOS = "repos";
    private static final String RESOURCE_KEY = "com.atlassian.stash.plugins.stash-hipchat-integration-plugin:soy-server-resources";
    private static final String SETTINGS_PAGE_CONTEXT = "bitbucket.page.repo.hipchat.settings";
    private static final String TEMPLATE_KEY = "bitbucket.internal.page.hipchat.repo.config.RepoSettings";
    private NotificationConfigurationContextBuilder notificationConfigurationContextBuilder;
    private PageBuilderService pageBuilderService;
    private PermissionValidationService permissionValidationService;
    private RepositoryService repositoryService;
    private SoyTemplateRenderer soyTemplateRenderer;

    public HipChatRepoSettingsServlet(NotificationConfigurationContextBuilder notificationConfigurationContextBuilder, PageBuilderService pageBuilderService, PermissionValidationService permissionValidationService, RepositoryService repositoryService, SoyTemplateRenderer soyTemplateRenderer) {
        this.notificationConfigurationContextBuilder = notificationConfigurationContextBuilder;
        this.pageBuilderService = pageBuilderService;
        this.permissionValidationService = permissionValidationService;
        this.repositoryService = repositoryService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Repository repository = this.getRepository(req);
        if (repository == null) {
            resp.sendError(404);
            return;
        }
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        this.prepareResponse(resp);
        this.render(resp, this.createViewContext(repository));
    }

    private Map<String, Object> createViewContext(Repository repository) {
        ImmutableMap.Builder<String, Object> contextBuilder = this.notificationConfigurationContextBuilder.createRepositoryViewContext(repository);
        this.notificationConfigurationContextBuilder.addHipChatViewContext(contextBuilder);
        return contextBuilder.build();
    }

    Repository getRepository(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (Strings.isNullOrEmpty((String)pathInfo) || pathInfo.equals("/")) {
            return null;
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        if (!this.isRepoPath(pathParts)) {
            return null;
        }
        String projectKey = pathParts[1];
        String repoSlug = pathParts[3];
        return this.repositoryService.getBySlug(projectKey, repoSlug);
    }

    private void handleSoyError(SoyException e) throws IOException, ServletException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new ServletException((Throwable)e);
    }

    private boolean isRepoPath(String[] pathParts) {
        return pathParts.length == 4 && PROJECTS.equals(pathParts[0]) && REPOS.equals(pathParts[2]);
    }

    private void prepareResponse(HttpServletResponse response) {
        this.pageBuilderService.assembler().resources().requireContext(SETTINGS_PAGE_CONTEXT);
        response.setContentType("text/html;charset=UTF-8");
    }

    private void render(HttpServletResponse response, Map<String, Object> context) throws ServletException, IOException {
        try {
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, context);
        }
        catch (SoyException soyException) {
            this.handleSoyError(soyException);
        }
    }
}

