/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration.restcompatibility;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.InviteUsersService;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.hipchat.api.Result;
import com.atlassian.plugins.hipchat.user.InvitationTracker;
import com.atlassian.plugins.hipchat.user.UserReference;
import com.atlassian.plugins.hipchat.user.UserReferenceSet;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class InviteUserResource
extends RestResource {
    private InvitationTracker invitationTracker;
    private InviteUsersService inviteUsersService;

    @Autowired
    public InviteUserResource(I18nService i18nService, InvitationTracker invitationTracker, InviteUsersService inviteUsersService) {
        super(i18nService);
        this.invitationTracker = invitationTracker;
        this.inviteUsersService = inviteUsersService;
    }

    @Path(value="/find-invite-users")
    @GET
    public Response findInviteUserNames(@Context ContainerRequest request) {
        Set<UserReference> userReferences = this.invitationTracker.hasPreviouslySuggestedInvitees() ? Collections.EMPTY_SET : this.inviteUsersService.getUserList(request.isSecure());
        UserReferenceSet userReferenceSet = new UserReferenceSet(userReferences);
        Result userNameSetResult = Result.success((Object)userReferenceSet);
        return Response.ok((Object)userNameSetResult.success()).build();
    }
}

