/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration.rest;

import com.atlassian.bitbucket.hipchat.notification.configuration.RepositoryConfiguration;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.rest.RestRoomConfiguration;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=RepositoryConfiguration.class)
public class RestRepositoryConfiguration {
    private final Iterable<RestRoomConfiguration> roomConfig;
    private final RestRepository repository;

    public RestRepositoryConfiguration(@Nonnull RepositoryConfiguration configuration) {
        this.roomConfig = Iterables.transform(configuration.getRoomConfigurations(), RestRoomConfiguration::new);
        this.repository = new RestRepository(configuration.getRepository());
    }

    @JsonProperty
    @Nonnull
    public Iterable<RestRoomConfiguration> getRoomConfigurations() {
        return this.roomConfig;
    }

    @JsonProperty
    @Nonnull
    public RestRepository getRepository() {
        return this.repository;
    }
}

