/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration;

import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.hipchat.notification.RepositoryLinkedEvent;
import com.atlassian.bitbucket.hipchat.notification.RepositoryNotificationDisabledEvent;
import com.atlassian.bitbucket.hipchat.notification.RepositoryNotificationEnabledEvent;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationConfigurationService;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationDisableRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationEnableRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationSearchRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.RepositoryConfiguration;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.AbstractNotificationRequest;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.dao.NotificationConfigurationDao;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultNotificationConfigurationService
implements NotificationConfigurationService {
    private final NotificationConfigurationDao dao;
    private final EventPublisher eventPublisher;
    private final PermissionValidationService permissionService;

    public DefaultNotificationConfigurationService(NotificationConfigurationDao dao, EventPublisher eventPublisher, PermissionValidationService permissionService) {
        this.dao = dao;
        this.eventPublisher = eventPublisher;
        this.permissionService = permissionService;
    }

    @Override
    public void disable(@Nonnull NotificationDisableRequest request) {
        this.checkPermission(request);
        this.dao.delete(request);
        this.eventPublisher.publish((Object)new RepositoryNotificationDisabledEvent(this, (Repository)request.getRepository().get(), request.getNotificationTypes(), (String)request.getRoomId().getOrNull()));
    }

    @Override
    public void enable(@Nonnull NotificationEnableRequest request) {
        this.checkPermission(request);
        Repository repository = (Repository)request.getRepository().get();
        String roomId = (String)request.getRoomId().get();
        NotificationSearchRequest searchRequest = ((NotificationSearchRequest.Builder)((Object)new NotificationSearchRequest.Builder().repository(repository))).build();
        Set<String> roomIds = this.getRoomIds(searchRequest);
        this.dao.create(request);
        if (!roomIds.contains(roomId)) {
            this.eventPublisher.publish((Object)new RepositoryLinkedEvent(this, repository, roomId));
        }
        this.eventPublisher.publish((Object)new RepositoryNotificationEnabledEvent(this, (Repository)request.getRepository().get(), request.getNotificationTypes(), (String)request.getRoomId().get()));
    }

    @Override
    @Nonnull
    public Set<String> getRoomIds(@Nonnull NotificationSearchRequest request) {
        return this.dao.getRoomIds(request);
    }

    @EventListener
    public void onRepositoryDeleted(@Nonnull RepositoryDeletedEvent event) {
        NotificationDisableRequest request = ((NotificationDisableRequest.Builder)((Object)new NotificationDisableRequest.Builder().repository(event.getRepository()))).build();
        this.dao.delete(request);
    }

    @Override
    @Nonnull
    public Page<RepositoryConfiguration> search(@Nonnull NotificationSearchRequest request, @Nonnull PageRequest pageRequest) {
        this.checkPermission(request);
        return this.dao.search(request, pageRequest);
    }

    private void checkPermission(AbstractNotificationRequest request) {
        Option<Repository> repository = request.getRepository();
        if (repository.isDefined()) {
            this.permissionService.validateForRepository((Repository)repository.get(), Permission.REPO_ADMIN);
        } else {
            this.permissionService.validateForGlobal(Permission.ADMIN);
        }
    }
}

