/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification;

import com.atlassian.bitbucket.hipchat.notification.NotificationTypeService;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotification;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationContext;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.atlassian.plugins.hipchat.descriptor.HipChatNotificationContextDescriptor;
import com.atlassian.plugins.hipchat.descriptor.HipChatNotificationDescriptor;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultNotificationTypeService
implements NotificationTypeService {
    private final I18nResolver i18nResolver;
    private final SafeAccessViaPluginAccessor safePluginAccessor;

    public DefaultNotificationTypeService(I18nResolver i18nResolver, PluginAccessor pluginAccessor) {
        this.safePluginAccessor = SafePluginPointAccess.to(pluginAccessor);
        this.i18nResolver = i18nResolver;
    }

    @Override
    public Iterable<NotificationType> getAll() {
        return this.safePluginAccessor.forType(HipChatNotificationDescriptor.class, (moduleDescriptor, module) -> NotificationType.fromModuleDescriptor((HipChatNotificationDescriptor)moduleDescriptor, (I18nResolver)this.i18nResolver, (HipChatNotification)module)).stream().sorted(Comparator.comparingInt(NotificationType::getWeight)).collect(Collectors.toList());
    }

    @Override
    public Map<String, HipChatNotificationContext> getAllContexts() {
        return this.safePluginAccessor.forType(HipChatNotificationContextDescriptor.class, (moduleDescriptor, module) -> Pair.pair((Object)moduleDescriptor.getValue(), (Object)module)).stream().collect(Collectors.toMap(pair -> (String)pair.left(), pair -> (HipChatNotificationContext)pair.right()));
    }

    @Override
    public Iterable<NotificationType> getByContext(String context) {
        Iterable<NotificationType> notificationTypes = this.getAll();
        return Iterables.filter(notificationTypes, notificationType -> notificationType.getContext().equals(context));
    }

    @Override
    public Option<NotificationType> getByKey(String key) {
        List<NotificationType> notifications = this.safePluginAccessor.forType(HipChatNotificationDescriptor.class, (moduleDescriptor, module) -> {
            if (key.equals(moduleDescriptor.getValue())) {
                return NotificationType.fromModuleDescriptor((HipChatNotificationDescriptor)moduleDescriptor, (I18nResolver)this.i18nResolver, (HipChatNotification)module);
            }
            return null;
        });
        Optional notificationType = Iterables.tryFind(notifications, input -> input != null);
        if (notificationType.isPresent()) {
            return Option.some((Object)notificationType.get());
        }
        return Option.none();
    }
}

