/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hipchat.notification.configuration;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public interface RoomDetails {
    @Nonnull
    public String getRoomId();

    @Nonnull
    public String getRoomName();

    @Nonnull
    public State getState();

    public static enum State {
        AVAILABLE(1, "Available"),
        FORBIDDEN(2, "Access denied"),
        ARCHIVED(3, "Archived"),
        NOT_FOUND(4, "Room could not be found"),
        UNKNOWN_ERROR(5, "An unknown error occured");

        private final int id;
        private final String statusMessage;

        private State(int id, String statusMessage) {
            this.id = id;
            this.statusMessage = (String)Preconditions.checkNotNull((Object)statusMessage, (Object)"statusMessage");
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String getStatusMessage() {
            return this.statusMessage;
        }
    }
}

