/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.tests.xctest;

import com.atlassian.bamboo.plugins.xcode.tests.api.XcodeTestParser;
import com.atlassian.bamboo.plugins.xcode.tests.xctest.QuickSpecTestResults;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class XCTestParser
implements XcodeTestParser {
    private static final Logger log = Logger.getLogger(XCTestParser.class);
    private static final String TEST_SUITE = "Test Suite";
    private static final String TEST_CASE = "Test Case";
    private static final String TEST_SUCCESS = "** TEST SUCCEEDED **";
    private static final String TEST_FAILED = "** TEST FAILED **";
    private final Set<TestResults> successfulTestResults = Sets.newHashSet();
    private final Set<TestResults> failingTestResults = Sets.newHashSet();
    private boolean testStarted;
    private String currentTestKey;
    private String currentSuiteName;
    private String currentTestName;
    private final Long currentTestDurationMs = 0L;
    private StringBuilder currentTestOutput = new StringBuilder();
    private List<String> currentTestErrors = Lists.newLinkedList();

    @Override
    public Set<TestResults> getSuccessfulTestResults() {
        return this.successfulTestResults;
    }

    @Override
    public Set<TestResults> getFailingTestResults() {
        return this.failingTestResults;
    }

    @Override
    public void processLine(@NotNull String line) {
        if (line.startsWith(TEST_SUITE)) {
            this.testStarted = true;
            int start = line.indexOf("'");
            int end = line.lastIndexOf("'");
            if (start > -1 && end > -1) {
                this.currentSuiteName = line.substring(start + 1, end);
            } else {
                log.warn((Object)"Could not parse test suite line");
            }
        } else if (line.startsWith(TEST_CASE)) {
            this.testStarted = true;
            int start = line.indexOf("'") + 1;
            int end = line.lastIndexOf("'");
            if (start > -1 && end > -1) {
                String testKey = line.substring(start + 1, end);
                String[] parts = testKey.split(" ");
                String testName = parts[1].replace("]", "");
                if (testKey.equals(this.currentTestKey)) {
                    TestState testState = line.contains("passed") ? TestState.SUCCESS : TestState.FAILED;
                    this.createTestCaseResult(testState);
                    this.resetState();
                } else {
                    this.currentTestKey = testKey;
                    this.currentTestName = testName;
                }
            } else {
                log.warn((Object)("Could not process line '" + line + "'"));
            }
        } else if (line.equals(TEST_FAILED) || line.equals(TEST_SUCCESS)) {
            System.out.println("Run completed");
            this.resetState();
        } else if (this.testStarted) {
            this.currentTestOutput.append(line);
        }
    }

    private void createTestCaseResult(TestState testState) {
        if (StringUtils.isNotEmpty((String)this.currentTestKey)) {
            TestResults testResults = this.makeTestResults();
            testResults.setSystemOut(this.currentTestOutput.toString());
            testResults.setState(testState);
            Set<TestResults> resultSet = testState == TestState.SUCCESS ? this.successfulTestResults : this.failingTestResults;
            resultSet.add(testResults);
        }
    }

    private TestResults makeTestResults() {
        if (QuickSpecTestResults.isQuickTestName(this.currentTestName)) {
            return new QuickSpecTestResults(this.currentSuiteName, this.currentTestName, this.currentTestDurationMs);
        }
        return new TestResults(this.currentSuiteName, this.currentTestName, this.currentTestDurationMs);
    }

    private void resetState() {
        this.testStarted = false;
        this.currentTestName = null;
        this.currentTestKey = null;
        this.currentTestOutput = new StringBuilder();
        this.currentTestErrors.clear();
    }
}

