/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.tests.ocunit;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.xcode.tests.ocunit.OCUnitTestParser;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class OCUnitTestTaskType
implements TaskType {
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        ConfigurationMap config = taskContext.getConfigurationMap();
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String logFileStr = (String)config.get((Object)"log_file");
        File logFile = new File(logFileStr);
        if (!logFile.exists()) {
            buildLogger.addBuildLogEntry("Could not find specified log file '" + logFile.getAbsolutePath() + "'");
            return taskResultBuilder.failed().build();
        }
        OCUnitTestParser parser = new OCUnitTestParser();
        try (FileInputStream is = new FileInputStream(logFile);){
            for (String line : IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8)) {
                parser.processLine(line);
            }
            taskContext.getBuildContext().getBuildResult().setTestResults((Set)Sets.newHashSet(parser.getSuccessfulTestResults()), (Set)Sets.newHashSet(parser.getFailingTestResults()));
            taskResultBuilder.checkTestFailures();
        }
        catch (FileNotFoundException e) {
            buildLogger.addErrorLogEntry("Could not find specified log file '" + logFile.getAbsolutePath() + "'", (Throwable)e);
            taskResultBuilder.failedWithError();
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("I/O Exception when accessing log file '" + logFile.getAbsolutePath() + "'", (Throwable)e);
            taskResultBuilder.failedWithError();
        }
        return taskResultBuilder.build();
    }
}

