/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.tests.ocunit;

import com.atlassian.bamboo.plugins.xcode.tests.api.XcodeTestParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.util.NumberUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnitTestParser
implements XcodeTestParser {
    private static final Logger log = Logger.getLogger(OCUnitTestParser.class);
    private static final Pattern TEST_ARCHITECTURE = Pattern.compile("Run unit tests for architecture '(\\S+)'.*");
    private static final Pattern START_SUITE = Pattern.compile("^.*Test Suite '(\\S+)'.*started at\\s+(.*)$");
    private static final Pattern END_SUITE = Pattern.compile("^.*Test Suite '(\\S+)'.*finished at\\s+(.*).$");
    private static final Pattern START_TESTCASE = Pattern.compile("^.*Test Case '-\\[\\S+\\s+(\\S+)\\]' started.$");
    private static final Pattern SUCCESSFUL_TESTCASE = Pattern.compile("^.*Test Case '-\\[\\S+\\s+(\\S+)\\]' passed \\((.*) seconds\\).$");
    private static final Pattern FAILED_TESTCASE = Pattern.compile("^.*Test Case '-\\[\\S+ (\\S+)\\]' failed \\((\\S+) seconds\\).$");
    private static final Pattern ERROR_TESTCASE = Pattern.compile("^.*(.*): error: -\\[(\\S+) (\\S+)\\] : (.*)$");
    private final Set<TestResults> successfulTestResults = Sets.newHashSet();
    private final Set<TestResults> failingTestResults = Sets.newHashSet();
    private String currentArchitecture;
    private String currentSuiteName;
    private String currentTestName;
    private Long currentTestDurationMs;
    private StringBuilder currentTestOutput = new StringBuilder();
    private List<String> currentTestErrors = Lists.newLinkedList();

    @Override
    public Set<TestResults> getSuccessfulTestResults() {
        return this.successfulTestResults;
    }

    @Override
    public Set<TestResults> getFailingTestResults() {
        return this.failingTestResults;
    }

    @Override
    public void processLine(@NotNull String line) {
        Matcher testCaseErrorMatcher;
        Matcher failedTestCaseMatcher;
        Matcher successfulTestCase;
        Matcher startTestCaseMatcher;
        Matcher endSuiteMatcher;
        Matcher startSuiteMatcher;
        Matcher architectureMatcher = TEST_ARCHITECTURE.matcher(line);
        if (architectureMatcher.matches()) {
            this.currentArchitecture = architectureMatcher.group(1);
            log.debug((Object)("Found test architecture '" + this.currentArchitecture + "'"));
        }
        if ((startSuiteMatcher = START_SUITE.matcher(line)).matches()) {
            this.currentSuiteName = startSuiteMatcher.group(1);
        }
        if ((endSuiteMatcher = END_SUITE.matcher(line)).matches()) {
            this.endTestSuite();
        }
        if ((startTestCaseMatcher = START_TESTCASE.matcher(line)).matches()) {
            this.currentTestName = startTestCaseMatcher.group(1);
        }
        if ((successfulTestCase = SUCCESSFUL_TESTCASE.matcher(line)).matches()) {
            this.currentTestDurationMs = OCUnitTestParser.toMilliseconds(successfulTestCase.group(2));
            this.recordRestResult(TestState.SUCCESS);
            this.endTestCase();
        }
        if ((failedTestCaseMatcher = FAILED_TESTCASE.matcher(line)).matches()) {
            this.currentTestDurationMs = OCUnitTestParser.toMilliseconds(failedTestCaseMatcher.group(2));
            this.recordRestResult(TestState.FAILED);
            this.endTestCase();
        }
        if ((testCaseErrorMatcher = ERROR_TESTCASE.matcher(line)).matches()) {
            this.currentTestErrors.add(line);
        }
        this.recordTestOutput(line);
    }

    private void recordRestResult(@NotNull TestState testState) {
        String suiteName = StringUtils.isNotEmpty((String)this.currentArchitecture) ? this.currentSuiteName + " (" + this.currentArchitecture + ")" : this.currentSuiteName;
        TestResults testResult = new TestResults(suiteName, this.currentTestName, this.currentTestDurationMs);
        testResult.setSystemOut(this.currentTestOutput.toString());
        testResult.setState(testState);
        if (testState == TestState.SUCCESS) {
            this.successfulTestResults.add(testResult);
        } else if (testState == TestState.FAILED) {
            for (String errorLine : this.currentTestErrors) {
                testResult.addError((TestCaseResultError)new TestCaseResultErrorImpl(errorLine));
            }
            this.failingTestResults.add(testResult);
        }
    }

    private void recordTestOutput(@NotNull String line) {
        if (StringUtils.isNotEmpty((String)this.currentSuiteName) && StringUtils.isNotEmpty((String)this.currentTestName)) {
            this.currentTestOutput.append(line);
            this.currentTestOutput.append('\n');
        }
    }

    private void endTestSuite() {
        this.currentSuiteName = null;
    }

    private void endTestCase() {
        this.currentTestName = null;
        this.currentTestOutput = new StringBuilder();
        this.currentTestErrors = Lists.newLinkedList();
    }

    @Nullable
    private static Long toMilliseconds(@Nullable String durationInSeconds) {
        Double durationDouble = NumberUtils.createDoubleQuietly((String)durationInSeconds);
        return durationDouble == null ? null : Long.valueOf((long)(durationDouble * 1000.0));
    }
}

