/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.testflight;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFlightTaskConfigurator
extends AbstractTaskConfigurator {
    public static final String FILE = "file";
    public static final String API_TOKEN = "api_token";
    public static final String TEAM_TOKEN = "team_token";
    public static final String NOTES = "notes";
    public static final String NOTIFY = "notify";
    public static final String REPLACE = "replace";
    public static final String DSYM = "dsym";
    public static final String DISTRIBUTION_LISTS = "distribution_lists";
    private static final Set<String> FIELDS = Sets.newHashSet((Object[])new String[]{"file", "dsym", "api_token", "team_token", "notes", "replace", "notify", "distribution_lists"});

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, FIELDS);
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(NOTES, "Released with Atlassian Bamboo");
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS);
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isEmpty((String)params.getString(API_TOKEN))) {
            errorCollection.addError(API_TOKEN, this.getI18nBean().getText("testflight.api_token.error"));
        }
        if (StringUtils.isEmpty((String)params.getString(TEAM_TOKEN))) {
            errorCollection.addError(TEAM_TOKEN, this.getI18nBean().getText("testflight.team_token.error"));
        }
        if (StringUtils.isEmpty((String)params.getString(FILE))) {
            errorCollection.addError(FILE, this.getI18nBean().getText("testflight.file.error"));
        }
        if (StringUtils.isEmpty((String)params.getString(NOTES))) {
            errorCollection.addError(NOTES, this.getI18nBean().getText("testflight.notes.error"));
        }
    }
}

