/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.hockeyapp;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;

public class CountingMultipartEntity
implements RequestEntity {
    private final RequestEntity entity;
    private final ProgressListener listener;

    public CountingMultipartEntity(RequestEntity entity, ProgressListener listener) {
        this.entity = entity;
        this.listener = listener;
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public String getContentType() {
        return this.entity.getContentType();
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public void writeRequest(OutputStream out) throws IOException {
        this.entity.writeRequest((OutputStream)new CountingOutputStream(out, this.listener));
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final ProgressListener listener;
        private long transferred;

        public CountingOutputStream(OutputStream out, ProgressListener listener) {
            super(out);
            this.listener = listener;
            this.transferred = 0L;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.transferred += (long)len;
            this.listener.transferred(this.transferred);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.transferred;
            this.listener.transferred(this.transferred);
        }
    }

    public static interface ProgressListener {
        public void transferred(long var1);
    }
}

