/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.export;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.FastlaneTask;
import com.atlassian.bamboo.specs.model.task.FastlaneTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FastlaneTaskExporter
implements TaskDefinitionExporter {
    static final ValidationContext FASTLANE_CONTEXT = ValidationContext.of((String)"Fastlane task");
    private final CapabilityContext capabilityContext;

    public FastlaneTaskExporter(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        FastlaneTaskProperties fastlaneTaskProperties = (FastlaneTaskProperties)Narrow.downTo((Object)taskProperties, FastlaneTaskProperties.class);
        if (fastlaneTaskProperties != null) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            cfg.put("lane", fastlaneTaskProperties.getLane());
            cfg.put("label", fastlaneTaskProperties.getExecutableLabel());
            cfg.put("environmentVariables", fastlaneTaskProperties.getEnvironmentVariables());
            cfg.put("workingSubDirectory", fastlaneTaskProperties.getWorkingSubdirectory());
            return cfg;
        }
        throw new IllegalStateException("Don't know how to import task properties of type: " + taskProperties.getClass().getName());
    }

    @NotNull
    public Task toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        FastlaneTask fastlaneTask = new FastlaneTask();
        return fastlaneTask.lane((String)configuration.get("lane")).executableLabel((String)configuration.get("label")).environmentVariables(configuration.getOrDefault("environmentVariables", "")).workingSubdirectory(configuration.getOrDefault("workingSubDirectory", ""));
    }

    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        ArrayList<ValidationProblem> result = new ArrayList<ValidationProblem>();
        FastlaneTaskProperties properties = (FastlaneTaskProperties)Narrow.downTo((Object)taskProperties, FastlaneTaskProperties.class);
        if (properties != null) {
            String executableLabel = properties.getExecutableLabel();
            if (StringUtils.isEmpty((CharSequence)executableLabel)) {
                result.add(new ValidationProblem(FASTLANE_CONTEXT, "Executable can't be empty"));
            }
            if (StringUtils.isEmpty((CharSequence)properties.getLane())) {
                result.add(new ValidationProblem(FASTLANE_CONTEXT, "Lane can't be empty"));
            } else {
                String capabilityKey = String.format("%s.%s", "system.builder.fastlane", properties.getExecutableLabel());
                if (StringUtils.isBlank((CharSequence)this.capabilityContext.getCapabilityValue(capabilityKey))) {
                    result.add(new ValidationProblem(FASTLANE_CONTEXT, "Executable " + properties.getExecutableLabel() + " doesn't exist."));
                }
            }
        }
        return result;
    }
}

