/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.build;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.build.logger.interceptors.ErrorMemorisingInterceptor;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportProvider;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.xcode.build.XCodeBuild;
import com.atlassian.bamboo.plugins.xcode.build.XCodeBuildLogInterceptor;
import com.atlassian.bamboo.plugins.xcode.tests.api.TestParserLogInterceptor;
import com.atlassian.bamboo.plugins.xcode.tests.ocunit.OCUnitTestParser;
import com.atlassian.bamboo.plugins.xcode.tests.xctest.XCTestParser;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class XCodeTaskType
implements TaskType {
    public static final String XCODE_CAPABILITY_PREFIX = "system.builder.xcode";
    public static final String XCRUN_PATH = "/usr/bin/xcrun";
    public static final String XCTEST_PATH = "/usr/bin/xcodebuild";
    private static final String XCWORKSPACE_EXTENSION = ".xcworkspace";
    private static final String XCODEPROJ_EXTENSION = ".xcodeproj";
    private final ProcessService processService;
    private final EnvironmentVariableAccessor environmentVariableAccessor;
    private final CapabilityContext capabilityContext;
    private final TestCollationService testCollationService;
    private static final Pattern PAT_ARGS = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");

    public XCodeTaskType(ProcessService processService, EnvironmentVariableAccessor environmentVariableAccessor, CapabilityContext capabilityContext, TestCollationService testCollationService) {
        this.processService = processService;
        this.environmentVariableAccessor = environmentVariableAccessor;
        this.capabilityContext = capabilityContext;
        this.testCollationService = testCollationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) throws TaskException {
        final TestParserLogInterceptor ocUnitLogInterceptor = new TestParserLogInterceptor(new OCUnitTestParser());
        final TestParserLogInterceptor xcTestParserLogInterceptor = new TestParserLogInterceptor(new XCTestParser());
        ErrorMemorisingInterceptor errorLogInterceptor = ErrorMemorisingInterceptor.newInterceptor();
        XCodeBuildLogInterceptor xcodebuildLogger = new XCodeBuildLogInterceptor();
        TaskResultBuilder resultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        BuildLogger buildLogger = taskContext.getBuildLogger();
        try {
            ConfigurationMap configurationMap = taskContext.getConfigurationMap();
            String project = (String)configurationMap.get((Object)"projectname");
            String workspace = (String)configurationMap.get((Object)"workspacename");
            String scheme = (String)configurationMap.get((Object)"schemename");
            String arch = (String)configurationMap.get((Object)"archname");
            boolean shouldClean = configurationMap.getAsBoolean("clean");
            File workingDirectory = taskContext.getWorkingDirectory();
            boolean buildAllTargets = configurationMap.getAsBoolean("alltargets");
            String target = (String)configurationMap.get((Object)"target");
            String configuration = (String)configurationMap.get((Object)"configuration");
            String sdk = (String)configurationMap.get((Object)"label");
            String customParameters = (String)configurationMap.get((Object)"customParameters");
            boolean parseOcUnitResults = configurationMap.getAsBoolean("ocunit");
            boolean parseXcUnitResults = configurationMap.getAsBoolean("xcunit");
            String runInIosSimStr = (String)MoreObjects.firstNonNull((Object)configurationMap.get((Object)"run_in_ios_sim"), (Object)"true");
            boolean runInSim = Boolean.parseBoolean(runInIosSimStr);
            String testSim = "'" + (String)configurationMap.get((Object)"test_sim") + "'";
            boolean resetSimulator = configurationMap.getAsBoolean("reset_simulator");
            String logfile = (String)configurationMap.get((Object)"logfile");
            boolean cleanLogfile = configurationMap.getAsBoolean("cleanLogfile");
            LinkedList arguments = Lists.newLinkedList();
            String sdkLabel = this.capabilityContext.getCapabilityValue("system.builder.xcode." + sdk);
            Preconditions.checkNotNull((Object)sdkLabel, (Object)"The Xcode SDK capability is missing");
            arguments.add(XCodeBuild.getXcodebuildPath());
            if (StringUtils.isNotEmpty((String)logfile)) {
                String logfilePath = workingDirectory.getPath() + "/" + logfile;
                try {
                    xcodebuildLogger.open(logfilePath, !cleanLogfile);
                    buildLogger.getInterceptorStack().add((LogInterceptor)xcodebuildLogger);
                }
                catch (IOException e) {
                    buildLogger.addBuildLogEntry("Cannot open logfile: " + e);
                }
            }
            if (shouldClean) {
                arguments.add("clean");
                arguments.add("build");
            }
            arguments.add("-sdk");
            arguments.add(sdkLabel);
            XCodeTaskType.addBuildConfigurationArgs(arguments, project, workspace, scheme);
            if (StringUtils.isNotEmpty((String)arch)) {
                arguments.add("-arch");
                arguments.add(arch);
            }
            if (StringUtils.isEmpty((String)scheme)) {
                if (buildAllTargets) {
                    arguments.add("-alltargets");
                } else if (StringUtils.isNotEmpty((String)target)) {
                    arguments.add("-target");
                    arguments.add(target);
                }
            }
            if (StringUtils.isNotEmpty((String)configuration)) {
                arguments.add("-configuration");
                arguments.add(configuration);
            }
            if (StringUtils.isNotEmpty((String)customParameters)) {
                XCodeTaskType.addArgumentsSplit(arguments, customParameters);
            }
            if (resetSimulator) {
                arguments.add("RESET_IOS_SIMULATOR=YES");
            }
            Map environment = this.environmentVariableAccessor.splitEnvironmentAssignments((String)configurationMap.get((Object)"environmentVariables"));
            if (parseOcUnitResults) {
                buildLogger.getInterceptorStack().add((LogInterceptor)ocUnitLogInterceptor);
            }
            buildLogger.getInterceptorStack().add((LogInterceptor)errorLogInterceptor);
            resultBuilder.checkReturnCode(this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().command((List)arguments).env(environment).workingDirectory(workingDirectory)));
            if (resultBuilder.getTaskState() == TaskState.SUCCESS && parseXcUnitResults) {
                buildLogger.getInterceptorStack().add((LogInterceptor)xcTestParserLogInterceptor);
                ArrayList testCommand = Lists.newArrayList((Object[])new String[]{XCTEST_PATH, "test"});
                XCodeTaskType.addBuildConfigurationArgs(testCommand, project, workspace, scheme);
                if (runInSim) {
                    testCommand.add("-destination");
                    testCommand.add(testSim);
                }
                if (StringUtils.isNotEmpty((String)customParameters)) {
                    XCodeTaskType.addArgumentsSplit(testCommand, customParameters);
                }
                resultBuilder.checkReturnCode(this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().workingDirectory(workingDirectory).command((List)testCommand)));
                this.testCollationService.collateTestResults(taskContext, new TestReportProvider(){

                    @NotNull
                    public TestCollectionResult getTestCollectionResult() {
                        return new TestCollectionResultBuilder().addFailedTestResults((Collection)Sets.union(ocUnitLogInterceptor.getFailingTestResults(), xcTestParserLogInterceptor.getFailingTestResults())).addSuccessfulTestResults((Collection)Sets.union(ocUnitLogInterceptor.getSuccessfulTestResults(), xcTestParserLogInterceptor.getSuccessfulTestResults())).build();
                    }
                });
                resultBuilder.checkTestFailures();
            }
            if (resultBuilder.getTaskState() == TaskState.SUCCESS && configurationMap.getAsBoolean("build_ipa")) {
                String appPath = (String)configurationMap.get((Object)"app_path");
                String identity = (String)configurationMap.get((Object)"identity");
                String devTeam = (String)configurationMap.get((Object)"development_team");
                String distribMethod = (String)configurationMap.get((Object)"distributionMethod");
                boolean uploadSymbols = configurationMap.getAsBoolean("includeSymbols");
                boolean uploadBitcode = configurationMap.getAsBoolean("includeBitcode");
                String provisioningProfile = (String)configurationMap.get((Object)"provisioning_profile");
                File appFile = new File(appPath);
                String xcarchivePath = FilenameUtils.removeExtension((String)appFile.getAbsolutePath()) + ".xcarchive";
                String exportOptionsPlist = FilenameUtils.getFullPath((String)appFile.getAbsolutePath()) + "exportOptions.plist";
                String outputPath = FilenameUtils.removeExtension((String)appFile.getAbsolutePath()) + ".ipa";
                ArrayList archiveCommand = Lists.newArrayList((Object[])new String[]{XCRUN_PATH, "-sdk", sdkLabel, "xcodebuild", "-workspace", workspace, "-scheme", scheme, "-sdk", "iphoneos"});
                if (StringUtils.isNotEmpty((String)configuration)) {
                    archiveCommand.add("-configuration");
                    archiveCommand.add(configuration);
                }
                archiveCommand.add("archive");
                archiveCommand.add("-archivePath");
                archiveCommand.add(xcarchivePath);
                if (StringUtils.isNotEmpty((String)identity)) {
                    archiveCommand.add("CODE_SIGN_IDENTITY=" + identity);
                }
                if (StringUtils.isNotEmpty((String)provisioningProfile)) {
                    archiveCommand.add("PROVISIONING_PROFILE=" + provisioningProfile);
                }
                ArrayList exportCommand = Lists.newArrayList((Object[])new String[]{XCRUN_PATH, "-sdk", sdkLabel, "xcodebuild", "-exportArchive", "-archivePath", xcarchivePath, "-exportOptionsPlist", exportOptionsPlist, "-exportPath", outputPath});
                resultBuilder.checkReturnCode(this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().workingDirectory(workingDirectory).command((List)archiveCommand)));
                if (resultBuilder.getTaskState() == TaskState.SUCCESS) {
                    buildLogger.addBuildLogEntry("xcarchive created at'" + xcarchivePath + "'");
                    XCodeTaskType.writeExportOptionsPlist(exportOptionsPlist, devTeam, distribMethod, uploadSymbols, uploadBitcode);
                    resultBuilder.checkReturnCode(this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().workingDirectory(workingDirectory).command((List)exportCommand)));
                    if (resultBuilder.getTaskState() == TaskState.SUCCESS) {
                        buildLogger.addBuildLogEntry("IPA created at '" + outputPath + "'");
                    }
                }
                if (StringUtils.isNotEmpty((String)sdk) && StringUtils.contains((String)sdk, (String)"simulator")) {
                    this.processService.executeExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().command((List)Lists.newArrayList((Object[])new String[]{"osascript", "-e", "'tell app \"iPhone Simulator\" to quit'"})));
                }
            }
            TaskResult taskResult = resultBuilder.build();
            return taskResult;
        }
        finally {
            buildLogger.getInterceptorStack().remove((LogInterceptor)ocUnitLogInterceptor);
            buildLogger.getInterceptorStack().remove((LogInterceptor)xcodebuildLogger);
            xcodebuildLogger.close();
        }
    }

    private static void addArgumentsSplit(List<String> arguments, String customParameters) {
        Matcher matcher = PAT_ARGS.matcher(customParameters);
        while (matcher.find()) {
            arguments.add(matcher.group());
        }
    }

    private static void addBuildConfigurationArgs(List<String> arguments, String project, String workspace, String scheme) {
        if (StringUtils.isNotEmpty((String)project)) {
            arguments.add("-project");
            if (!StringUtils.endsWith((String)project, (String)XCODEPROJ_EXTENSION)) {
                project = project + XCODEPROJ_EXTENSION;
            }
            arguments.add(project);
        }
        if (StringUtils.isNotEmpty((String)workspace)) {
            arguments.add("-workspace");
            if (!StringUtils.endsWith((String)workspace, (String)XCWORKSPACE_EXTENSION)) {
                workspace = workspace + XCWORKSPACE_EXTENSION;
            }
            arguments.add(workspace);
        }
        if (StringUtils.isNotEmpty((String)scheme)) {
            arguments.add("-scheme");
            arguments.add(scheme);
        }
    }

    private static void writeExportOptionsPlist(String plistPath, String devTeam, String distribMethod, boolean uploadSymbols, boolean uploadBitcode) throws TaskException {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">");
        builder.append("<plist version=\"1.0\">");
        builder.append("<dict>");
        builder.append("<key>method</key>");
        builder.append("<string>").append(distribMethod).append("</string>");
        builder.append("<key>teamID</key>");
        builder.append("<string>").append(devTeam).append("</string>");
        builder.append("<key>uploadSymbols</key>");
        builder.append(uploadSymbols ? "<true/>" : "<false/>");
        builder.append("<key>uploadBitcode</key>");
        builder.append(uploadBitcode ? "<true/>" : "<false/>");
        builder.append("</dict>");
        builder.append("</plist>");
        try {
            Files.write(Paths.get(plistPath, new String[0]), builder.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new TaskException("failed to generate and/or write xcodebuild export options plist", (Throwable)e);
        }
    }
}

