/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.build;

import com.atlassian.bamboo.plugins.xcode.build.XCodeBuild;
import com.atlassian.bamboo.plugins.xcode.build.sdk.Sdk;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractCapabilityTypeModule;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XCodeSDKCapabilityTypeModule
extends AbstractCapabilityTypeModule
implements CapabilityDefaultsHelper {
    private static final String SDK = "sdk";
    private static final String NAME = "name";
    @Inject
    private TextProvider textProvider;

    @NotNull
    public Map<String, String> validate(@NotNull Map<String, String[]> params) {
        HashMap map = Maps.newHashMap();
        if (StringUtils.isEmpty((String)this.getParamValue(params, SDK))) {
            map.put(SDK, this.textProvider.getText("xcode.sdk.label.error"));
        }
        if (StringUtils.isEmpty((String)this.getParamValue(params, NAME))) {
            map.put(NAME, this.textProvider.getText("xcode.sdk.name.error"));
        }
        return map;
    }

    @NotNull
    public Capability getCapability(@NotNull Map<String, String[]> params) {
        String sdkName = this.getParamValue(params, NAME);
        String sdkLabel = this.getParamValue(params, SDK);
        return this.createXcodeSdkCapability(sdkName, sdkLabel);
    }

    @NotNull
    public String getLabel(@NotNull String key) {
        return null;
    }

    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySet) {
        String xcodebuildPath = XCodeBuild.getXcodebuildPath();
        if (StringUtils.isNotBlank((String)xcodebuildPath) && new File(xcodebuildPath).exists()) {
            for (Sdk sdk : XCodeBuild.findSdks()) {
                Capability capability = this.createXcodeSdkCapability(sdk.getName(), sdk.getLabel());
                capabilitySet.addCapability(capability);
            }
        }
        return capabilitySet;
    }

    private Capability createXcodeSdkCapability(String sdkName, String sdkLabel) {
        return new CapabilityImpl("system.builder.xcode." + sdkName, sdkLabel);
    }

    @Nullable
    private String getParamValue(@NotNull Map<String, String[]> params, @NotNull String key) {
        String[] param = params.get(key);
        if (param != null && param.length > 0) {
            return param[0];
        }
        return null;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

