/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.xcode.build;

import com.atlassian.bamboo.plugins.xcode.build.sdk.Sdk;
import com.atlassian.bamboo.plugins.xcode.build.sdk.SdkType;
import com.atlassian.bamboo.utils.Which;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.StringProcessHandler;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class XCodeBuild {
    public static final String XCODEBUILD = "xcodebuild";
    public static final String XCODEBUILD_ARG_SHOWSDKS = "-showsdks";
    public static final String XCODEBUILD_ARG_CLEAN = "clean";
    private static final LazyReference<String> xcodeBuildPathLazyRef = new LazyReference<String>(){

        protected String create() throws Exception {
            return Which.execute((String)XCodeBuild.XCODEBUILD);
        }
    };

    public static String getXcodebuildPath() {
        return (String)xcodeBuildPathLazyRef.get();
    }

    public static Set<Sdk> findSdks() {
        LinkedHashSet<Sdk> sdks = new LinkedHashSet<Sdk>();
        StringProcessHandler processHandler = new StringProcessHandler();
        new ExternalProcessBuilder().command(Arrays.asList(XCodeBuild.getXcodebuildPath(), XCODEBUILD_ARG_SHOWSDKS)).handler((ProcessHandler)processHandler).build().execute();
        String output = processHandler.getOutput();
        SdkType currentSdkType = null;
        block0: for (String line : output.split("\n")) {
            if (currentSdkType == null) {
                for (SdkType sdkType : SdkType.values()) {
                    if (!line.startsWith(sdkType.getName())) continue;
                    currentSdkType = sdkType;
                    continue block0;
                }
                continue;
            }
            if (line.startsWith("\t")) {
                String[] split = StringUtils.split((String)line, (String)"\t");
                if (split.length != 2) {
                    throw new IllegalStateException("Could not split line into two equal parts '" + line + "'");
                }
                String sdkName = StringUtils.trim((String)split[0]);
                String sdkLabel = StringUtils.trim((String)StringUtils.remove((String)split[1], (String)"-sdk "));
                sdks.add(new Sdk(currentSdkType, sdkName, sdkLabel));
                continue;
            }
            currentSdkType = null;
        }
        return sdks;
    }
}

