/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.tomcat.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.tomcat.configuration.AbstractTomcatConfigurator;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeployAppConfigurator
extends AbstractTomcatConfigurator {
    private static final Logger log = Logger.getLogger(DeployAppConfigurator.class);
    public static final String APP_VERSION = "appVersion";
    public static final String WAR_FILE_PATH = "warFilePath";
    public static final String DEPLOYMENT_TAG = "deploymentTag";
    private static final Set<String> FIELDS_TO_COPY = ImmutableSet.builder().add((Object[])new String[]{"appVersion", "warFilePath", "deploymentTag"}).build();

    @Override
    protected Set<String> getFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (StringUtils.isEmpty((String)params.getString(WAR_FILE_PATH))) {
            errorCollection.addError(WAR_FILE_PATH, this.textProvider.getText("tomcat.war.error"));
        }
    }
}

