package com.atlassian.bamboo.plugins.tomcat.manager;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Provides access to the Tomcat Application Manager of a single Tomcat server.
 */
public interface TomcatApplicationManager
{
    /**
     * @return list of all applications on the Tomcat server
     * @throws IOException
     */
    @NotNull
    List<Application> listApplications() throws IOException;

    /**
     * @param contextPath of the application
     * @return application registered at the given context path
     * @throws IOException
     */
    @Nullable
    Application getApplicationByContext(@NotNull String contextPath) throws IOException;

    /**
     * Starts a Tomcat application at the give context path
     * @param contextPath
     * @return result
     * @throws IOException
     */
    @NotNull
    TomcatResult startApplication(@NotNull String contextPath) throws IOException;

    /**
     * Reloads a Tomcat application at the give context path
     * @param contextPath
     * @return result
     * @throws IOException
     */
    @NotNull
    TomcatResult reloadApplication(@NotNull String contextPath) throws IOException;

    /**
     * Stops a Tomcat application at the give context path
     * @param contextPath
     * @return result
     * @throws IOException
     */
    @NotNull
    TomcatResult stopApplication(@NotNull String contextPath) throws IOException;

    /**
     * Undeploys a Tomcat application at the give context path
     * @param contextPath
     * @return result
     * @throws IOException
     */
    @NotNull
    TomcatResult undeployApplication(@NotNull String contextPath) throws IOException;

    /**
     * Deploys a Tomcat application at the give context path
     * @param contextPath
     * @return result
     * @throws IOException
     */
    @NotNull
    TomcatResult deployApplication(@NotNull String contextPath, @Nullable String version, @NotNull String deploymentTag, @NotNull File file) throws IOException;
}
