/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.testresultparser.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskConfiguratorHelper;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskTestResultsSupport;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestResultsParserTaskConfigurator
extends AbstractTaskConfigurator
implements TaskTestResultsSupport {
    private static final String DEFAULT_TEST_RESULTS_PATTERN = "**/test-reports/*.xml";
    private static final List<String> FIELDS_TO_COPY = Arrays.asList("testResultsDirectory", "pickupOutdatedFiles");
    private final I18nResolver i18nResolver;

    @Inject
    public TestResultsParserTaskConfigurator(@BambooImport I18nResolver i18nResolver, @BambooImport TaskConfiguratorHelper taskConfiguratorHelper) {
        this.i18nResolver = i18nResolver;
        this.setTaskConfiguratorHelper(taskConfiguratorHelper);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(config, params, FIELDS_TO_COPY);
        return config;
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        context.put("testResultsDirectory", DEFAULT_TEST_RESULTS_PATTERN);
        context.put("pickupOutdatedFiles", Boolean.FALSE);
    }

    protected void validateTestResultsFilePattern(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        if (StringUtils.isEmpty((CharSequence)params.getString("testResultsDirectory"))) {
            errorCollection.addError("testResultsDirectory", this.i18nResolver.getText("task.generic.validate.testResultsPattern.mandatory"));
        }
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        this.validateTestResultsFilePattern(params, errorCollection);
    }

    public boolean taskProducesTestResults(@NotNull TaskDefinition taskDefinition) {
        return true;
    }
}

