[#-- @ftlvariable name="resultsSummary" type="com.atlassian.bamboo.resultsummary.ResultsSummary" --]
[#-- @ftlvariable name="repositoryChangeset" type="com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset" --]

[#if repositoryChangeset.commits?has_content]
    [@ui.bambooInfoDisplay title=repositoryChangeset.repositoryData.name?html headerWeight='h2']
        <ul>
        [#list repositoryChangeset.commits.toArray()?sort_by("date")?reverse as commit]
            <li>
                [@ui.displayAuthorAvatarForCommit commit=commit avatarSize='25' /]
                <h3>
                    <a href="[@cp.displayAuthorOrProfileLink author=commit.author /]">[@ui.displayAuthorFullName author=commit.author /]</a>
                    <span class="revision-date">
                        [@ui.time datetime=commit.date relative=true /]
                    </span>
                    [#assign commitUrl = (linkGenerator.getWebRepositoryUrlForCommit(commit, repositoryData))!('') /]
                    [#if commitUrl?has_content]
                        <a href="${commitUrl}" class="revision-id" title="[@ww.text name="webRepositoryViewer.stash.viewChangeset" /]">${commit.changeSetId!}</a>
                    [#else ]
                        <span class="revision-id" title="[@ww.text name='webRepositoryViewer.stash.error.cantCreateUrl' /]">${commit.changeSetId!}</span>
                    [/#if]
                </h3>
                <p>[@ui.renderValidJiraIssues commit.comment buildResultsSummary /]</p>
                <ul class="files">
                    [#list commit.files as file]
                    <li>
                        [#if file.revision?has_content]
                            [#assign fileLink = linkGenerator.getStashUrlForFile(file, repositoryData)!]
                            [#if fileLink?has_content ]
                                <a href="${linkGenerator.getStashUrlForFileAtItsRevision(file, repositoryData)}"
                                    title="[@ww.text name='webRepositoryViewer.stash.viewFileAtRevision'][@ww.param]${file.revision}[/@ww.param][/@ww.text]">
                                    ${file.cleanName}</a>
                                <a href="${linkGenerator.getStashUrlForFileDiff(file, repositoryData)}"
                                    title="[@ww.text name='webRepositoryViewer.stash.compareFileWithPrevious' /]">
                                    [@ww.text name='webRepositoryViewer.stash.label.diffs' /]
                                </a>
                            [#else]
                                ${file.cleanName}
                            [/#if]
                        [#else]
                            ${file.cleanName}
                        [/#if]
                    </li>
                    [/#list]
                </ul>
            </li>
        [/#list]
        </ul>
    [/@ui.bambooInfoDisplay]
[/#if]
