/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.script.task.export;

import com.atlassian.bamboo.plugins.script.task.ScriptConfig;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.ScriptTask;
import com.atlassian.bamboo.specs.model.task.ScriptTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ScriptTaskExporter
implements TaskDefinitionExporter {
    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        ScriptTaskProperties scriptTaskProperties = (ScriptTaskProperties)Narrow.downTo((Object)taskProperties, ScriptTaskProperties.class);
        if (scriptTaskProperties != null) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            switch (scriptTaskProperties.getLocation()) {
                case FILE: {
                    cfg.put("scriptLocation", ScriptConfig.ScriptLocation.FILE.name());
                    cfg.put("script", scriptTaskProperties.getPath());
                    break;
                }
                case INLINE: {
                    cfg.put("scriptLocation", ScriptConfig.ScriptLocation.INLINE.name());
                    cfg.put("scriptBody", scriptTaskProperties.getBody());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported script location: " + scriptTaskProperties.getInterpreter());
                }
            }
            switch (scriptTaskProperties.getInterpreter()) {
                case SHELL: {
                    cfg.put("interpreter", ScriptConfig.Interpreter.RUN_AS_EXECUTABLE.name());
                    break;
                }
                case WINDOWS_POWER_SHELL: {
                    cfg.put("interpreter", ScriptConfig.Interpreter.POWERSHELL.name());
                    break;
                }
                case BINSH_OR_CMDEXE: {
                    cfg.put("interpreter", ScriptConfig.Interpreter.LEGACY_SH_BAT.name());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported script interpreter: " + scriptTaskProperties.getInterpreter());
                }
            }
            if (scriptTaskProperties.getArgument() != null) {
                cfg.put("argument", scriptTaskProperties.getArgument());
            }
            if (scriptTaskProperties.getEnvironmentVariables() != null) {
                cfg.put("environmentVariables", scriptTaskProperties.getEnvironmentVariables());
            }
            if (scriptTaskProperties.getWorkingSubdirectory() != null) {
                cfg.put("workingSubDirectory", scriptTaskProperties.getWorkingSubdirectory());
            }
            return cfg;
        }
        throw new IllegalStateException("Don't know how to import task properties of type: " + taskProperties.getClass().getName());
    }

    @NotNull
    public ScriptTask toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map taskConfiguration = taskDefinition.getConfiguration();
        ScriptTask taskBuilder = new ScriptTask();
        ScriptConfig.ScriptLocation location = ScriptConfig.ScriptLocation.valueOf((String)taskConfiguration.get("scriptLocation"));
        switch (location) {
            case FILE: {
                taskBuilder.fileFromPath((String)taskConfiguration.get("script"));
                break;
            }
            case INLINE: {
                taskBuilder.inlineBody((String)taskConfiguration.get("scriptBody"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported script location: " + (Object)((Object)location));
            }
        }
        ScriptConfig.Interpreter interpreter = ScriptConfig.Interpreter.valueOf((String)taskConfiguration.get("interpreter"));
        switch (interpreter) {
            case RUN_AS_EXECUTABLE: {
                taskBuilder.interpreter(ScriptTaskProperties.Interpreter.SHELL);
                break;
            }
            case POWERSHELL: {
                taskBuilder.interpreter(ScriptTaskProperties.Interpreter.WINDOWS_POWER_SHELL);
                break;
            }
            case LEGACY_SH_BAT: {
                taskBuilder.interpreter(ScriptTaskProperties.Interpreter.BINSH_OR_CMDEXE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported script interpreter: " + (Object)((Object)interpreter));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)taskConfiguration.get("argument")))) {
            taskBuilder.argument((String)taskConfiguration.get("argument"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)taskConfiguration.get("environmentVariables")))) {
            taskBuilder.environmentVariables((String)taskConfiguration.get("environmentVariables"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)taskConfiguration.get("workingSubDirectory")))) {
            taskBuilder.workingSubdirectory((String)taskConfiguration.get("workingSubDirectory"));
        }
        return taskBuilder;
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        return Collections.emptyList();
    }
}

