/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.command.task.export;

import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.CommandTask;
import com.atlassian.bamboo.specs.model.task.CommandTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class CommandTaskExporter
implements TaskDefinitionExporter {
    private static final Logger log = Logger.getLogger(CommandTaskExporter.class);
    private static final ValidationContext COMMAND_CONTEXT = ValidationContext.of((String)"Command task");
    @Autowired
    private UIConfigSupport uiConfigSupport;

    @NotNull
    public CommandTask toSpecsEntity(TaskDefinition taskDefinition) {
        String workingSubdirectory;
        String environmentVariables;
        String argument;
        CommandTask commandTask = new CommandTask();
        Map configuration = taskDefinition.getConfiguration();
        String executable = (String)configuration.get("label");
        if (!StringUtils.isEmpty((CharSequence)executable)) {
            commandTask.executable(executable);
        }
        if (!StringUtils.isEmpty((CharSequence)(argument = (String)configuration.get("argument")))) {
            commandTask.argument(argument);
        }
        if (!StringUtils.isEmpty((CharSequence)(environmentVariables = (String)configuration.get("environmentVariables")))) {
            commandTask.environmentVariables(environmentVariables);
        }
        if (!StringUtils.isEmpty((CharSequence)(workingSubdirectory = (String)configuration.get("workingSubDirectory")))) {
            commandTask.workingSubdirectory(workingSubdirectory);
        }
        return commandTask;
    }

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        CommandTaskProperties commandTaskProperties = (CommandTaskProperties)Narrow.downTo((Object)taskProperties, CommandTaskProperties.class);
        if (commandTaskProperties != null) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            if (commandTaskProperties.getExecutable() != null) {
                cfg.put("label", commandTaskProperties.getExecutable());
            }
            if (commandTaskProperties.getArgument() != null) {
                cfg.put("argument", commandTaskProperties.getArgument());
            }
            if (commandTaskProperties.getEnvironmentVariables() != null) {
                cfg.put("environmentVariables", commandTaskProperties.getEnvironmentVariables());
            }
            if (commandTaskProperties.getWorkingSubdirectory() != null) {
                cfg.put("workingSubDirectory", commandTaskProperties.getWorkingSubdirectory());
            }
            return cfg;
        }
        throw new IllegalStateException("Don't know how to import task properties of type: " + taskProperties.getClass().getName());
    }

    @NotNull
    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        ArrayList<ValidationProblem> result = new ArrayList<ValidationProblem>();
        CommandTaskProperties commandTaskProperties = (CommandTaskProperties)Narrow.downTo((Object)taskProperties, CommandTaskProperties.class);
        List labels = this.uiConfigSupport.getExecutableLabels("command");
        String label = commandTaskProperties.getExecutable();
        if (labels == null || !labels.contains(label)) {
            result.add(new ValidationProblem(COMMAND_CONTEXT, "Can't find executable by label: '" + label + "'. Available values: " + labels));
        }
        return result;
    }
}

