/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.command.task;

import com.atlassian.bamboo.plugins.shell.task.ShellConfig;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CommandConfig
implements ShellConfig {
    private static final Logger log = Logger.getLogger(CommandConfig.class);
    public static final String CFG_SCRIPT = "label";
    public static final String CFG_ARGUMENT = "argument";
    public static final String CFG_ENVIRONMENT_VARIABLES = "environmentVariables";
    public static final String CAPABILITY_SHORT_KEY = "command";
    public static final String COMMAND_CAPABILITY_PREFIX = "system.builder.command";
    private final File workingDirectory;
    private final String label;
    private final String script;
    private final List<String> parameters;
    private final Map<String, String> extraEnvironment = new HashMap<String, String>();

    public CommandConfig(@NotNull CommonTaskContext taskContext, @NotNull CapabilityContext capabilityContext, @NotNull EnvironmentVariableAccessor environmentVariableAccessor) {
        this.workingDirectory = taskContext.getWorkingDirectory();
        this.label = (String)taskContext.getConfigurationMap().get((Object)CFG_SCRIPT);
        this.script = capabilityContext.getCapabilityValue("system.builder.command." + this.label);
        this.parameters = CommandlineStringUtils.tokeniseCommandline((String)StringUtils.replaceChars((String)((String)taskContext.getConfigurationMap().get((Object)CFG_ARGUMENT)), (String)"\r\n", (String)"  "));
        String environmentVariables = (String)taskContext.getConfigurationMap().get((Object)CFG_ENVIRONMENT_VARIABLES);
        this.extraEnvironment.putAll(environmentVariableAccessor.splitEnvironmentAssignments(environmentVariables, false));
    }

    @Override
    public List<String> getCommandline() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.script);
        if (!this.parameters.isEmpty()) {
            arguments.addAll(this.parameters);
        }
        return arguments;
    }

    @Override
    public Map<String, String> getExtraEnvironment() {
        return this.extraEnvironment;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public boolean isRunWithPowershell() {
        return false;
    }
}

