[#import "/lib/ace.ftl" as ace ]

[@ww.select
        labelKey='task.script.location'
        listKey='key'
        listValue='value'
        list=locationTypes
        name='scriptLocation'
        toggle=true /]

[@ww.checkbox labelKey='task.script.powershell' name='runWithPowershell'/]

[@ui.bambooSection dependsOn='scriptLocation' showOn='FILE']
    [@ww.textfield labelKey='task.script.script' name='script' required=true cssClass="long-field" /]
[/@ui.bambooSection]

[@ui.bambooSection dependsOn='scriptLocation' showOn='INLINE']
    [@ace.textarea labelKey='task.script.body' name="scriptBody" required=true/]
[/@ui.bambooSection]

<script type="text/javascript">
    (function ($)  {
        syntaxHighlightingUpdate = function() {
            var editor = scriptBody_ref,
                    DefaultHighlightMode = ace.require("ace/mode/sh").Mode,
                    PowershellHighlightMode = ace.require("ace/mode/powershell").Mode;
            if ($("#runWithPowershell").is(':checked')) {
                editor.getSession().setMode(new PowershellHighlightMode());
            } else {
                editor.getSession().setMode(new DefaultHighlightMode());
            }
        }
        $("#runWithPowershell").on('change', syntaxHighlightingUpdate);
        syntaxHighlightingUpdate();
    }(jQuery));
</script>

[@ww.textfield labelKey='task.script.argument' name='argument' cssClass="long-field" /]

[@ww.textfield labelKey='builder.common.env' name='environmentVariables' cssClass="long-field" /]
[@ww.textfield labelKey='builder.common.sub' name='workingSubDirectory' cssClass="long-field" /]
