/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.shell.conversion;

import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import com.atlassian.bamboo.task.conversion.AbstractBuilder2TaskConverter;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractShellBuilder2TaskConverter
extends AbstractBuilder2TaskConverter {
    private static final Logger log = Logger.getLogger(AbstractShellBuilder2TaskConverter.class);
    private static final String JUNIT_TEST_RESULT_PARSER_TASK_PLUGIN_KEY = "com.atlassian.bamboo.plugins.testresultparser:task.testresultparser.junit";
    protected final String builderConfigKey;
    private final boolean includeJUnitTask;

    protected AbstractShellBuilder2TaskConverter(String builderConfigKey, boolean includeJUnitTask) {
        this.builderConfigKey = builderConfigKey;
        this.includeJUnitTask = includeJUnitTask;
    }

    protected Map<String, String> filterOutTestParameters(Map<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>(params);
        result.remove("testChecked");
        result.remove("testResultsDirectory");
        return result;
    }

    protected abstract String getTaskPluginKey();

    @NotNull
    public List<TaskDefinition> builder2TaskList(@NotNull BuildConfiguration buildConfiguration) {
        ArrayList taskDefinitions = Lists.newArrayList();
        Map strippedParams = this.stripBuilderParameters(buildConfiguration, this.builderConfigKey);
        boolean hasTests = Boolean.parseBoolean((String)strippedParams.get("testChecked"));
        taskDefinitions.add(new TaskDefinitionImpl(this.incrementTaskId.get().longValue(), this.getTaskPluginKey(), "", true, this.filterOutTestParameters(strippedParams)));
        if (this.includeJUnitTask && hasTests) {
            HashMap testParserParams = new HashMap();
            testParserParams.put("testResultsDirectory", strippedParams.get("testResultsDirectory"));
            taskDefinitions.add(new TaskDefinitionImpl(this.incrementTaskId.get().longValue(), JUNIT_TEST_RESULT_PARSER_TASK_PLUGIN_KEY, "Parsing test results produced by script", testParserParams, true));
        }
        return taskDefinitions;
    }
}

