/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.script.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.script.task.ScriptConfig;
import com.atlassian.bamboo.plugins.shell.configuration.AbstractShellCommandTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.core.util.PairType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ScriptBuildTaskConfigurator
extends AbstractShellCommandTaskConfigurator {
    private static final String CFG_LOCATION_TYPES = "locationTypes";
    private static final List<String> FIELDS_TO_COPY = ImmutableList.of((Object)"environmentVariables", (Object)"workingSubDirectory", (Object)"script", (Object)"scriptBody", (Object)"argument", (Object)"scriptLocation", (Object)"runWithPowershell");
    private TextProvider textProvider;

    @Override
    @NotNull
    protected List<String> getFieldsToCopy() {
        return FIELDS_TO_COPY;
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        ScriptConfig.ScriptLocation location = ScriptConfig.ScriptLocation.valueOf(params.getString("scriptLocation"));
        String requiredParam = null;
        String validationMessage = null;
        switch (location) {
            case INLINE: {
                requiredParam = "scriptBody";
                validationMessage = "task.script.validate.script.body.mandatory";
                break;
            }
            case FILE: {
                requiredParam = "script";
                validationMessage = "task.script.validate.script.file.mandatory";
            }
        }
        if (StringUtils.isEmpty((String)params.getString(requiredParam))) {
            errorCollection.addError(requiredParam, this.textProvider.getText(validationMessage));
        }
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put(CFG_LOCATION_TYPES, this.getLocationTypes());
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put(CFG_LOCATION_TYPES, this.getLocationTypes());
    }

    public List<PairType> getLocationTypes() {
        PairType file = new PairType((Serializable)((Object)ScriptConfig.ScriptLocation.FILE.toString()), (Serializable)((Object)this.textProvider.getText("task.script.location.filesystem")));
        PairType inline = new PairType((Serializable)((Object)ScriptConfig.ScriptLocation.INLINE.toString()), (Serializable)((Object)this.textProvider.getText("task.script.location.inline")));
        return Lists.newArrayList((Object[])new PairType[]{inline, file});
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

