/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.script.task;

import com.atlassian.bamboo.plugins.script.task.ScriptConfig;
import com.atlassian.bamboo.plugins.shell.task.AbstractShellBuildTask;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.util.BambooAceUtils;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ScriptBuildTask
extends AbstractShellBuildTask {
    private static final Logger log = Logger.getLogger(ScriptBuildTask.class);

    public ScriptBuildTask(EnvironmentVariableAccessor environmentVariableAccessor, ProcessService processService) {
        super(environmentVariableAccessor, processService);
    }

    @Override
    protected ScriptConfig getConfig(@NotNull CommonTaskContext taskContext) {
        return new ScriptConfig(taskContext, this.environmentVariableAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public TaskResult execute(@NotNull CommonTaskContext taskContext) throws TaskException {
        TaskResult taskResult;
        ScriptConfig config = this.getConfig(taskContext);
        File scriptFile = null;
        try {
            if (config.getScriptLocation() == ScriptConfig.ScriptLocation.INLINE) {
                scriptFile = this.createTemporaryScriptFile(taskContext, config, scriptFile);
            }
            taskResult = super.execute(taskContext, config);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(scriptFile);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)scriptFile);
        return taskResult;
    }

    private File createTemporaryScriptFile(CommonTaskContext taskContext, ScriptConfig config, File scriptFile) throws TaskException {
        try {
            String prefix = taskContext.getCommonContext().getResultKey().getKey() + "-" + this.getClass().getSimpleName() + "-";
            scriptFile = File.createTempFile(prefix, config.isRunWithPowershell() ? ".ps1" : BambooFilenameUtils.getScriptSuffix());
            FileUtils.writeStringToFile((File)scriptFile, (String)BambooAceUtils.getContentForCurrentPlaform((String)config.getScriptBody()));
            scriptFile.setReadOnly();
            config.setScriptFilename(scriptFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new TaskException("Error while creating temporary file for script", (Throwable)e);
        }
        return scriptFile;
    }
}

