/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcsversion;

import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.cvsimpl.CVSRepository;
import com.atlassian.bamboo.repository.perforce.PerforceRepository;
import com.atlassian.bamboo.repository.svn.SvnRepository;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyVariableGenerator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.VcsVariableGenerator;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VCSVersionReader
extends AbstractBuildTask
implements CustomPreBuildAction {
    private static final String CUSTOM_SVN = "custom.svn";
    private static final String CUSTOM_CVS = "custom.cvs";
    private static final String CUSTOM_P4 = "custom.p4";
    private static final String REVISION_NUMBER = "revision.number";
    private static final String USER_NAME = "username";
    public static final String SVN_REVISION_NUMBER = "custom.svn.revision.number";
    public static final String SVN_USER_NAME = "custom.svn.username";
    public static final String CVS_UPDATE_TIME = "custom.cvs.last.update.time";
    public static final String CVS_UPDATE_TIME_LABEL = "custom.cvs.last.update.time.label";
    public static final String P4_REVISION_NUMBER = "custom.p4.revision.number";
    public static final String P4_LASTCHANGE_REVISION_NUMBER = "custom.p4.lastchange.revision.number";
    public static final String P4_USER_NAME = "custom.p4.username";
    private static final String P4_PORT = "custom.p4.port";
    private static final String P4_CLIENT = "custom.p4.client";
    private static final String REPOSITORY_NAME = "repository.name";
    private static final String REPOSITORY_REVISION_NUMBER = "repository.revision.number";
    private static final String REPOSITORY_PREVIOUS_REVISION_NUMBER = "repository.previous.revision.number";
    private static final String REPOSITORY_BRANCH_NAME = "repository.branch.name";
    Map<String, Integer> jobRepositoryOccurences = new HashMap<String, Integer>();
    boolean changesetHasNoTriggeringRepositories = false;
    private CustomVariableContext customVariableContext;
    private VcsRepositoryManager vcsRepositoryManager;

    @NotNull
    public BuildContext call() {
        this.processBuildContext(this.buildContext);
        this.processBuildContext(this.buildContext.getParentBuildContext());
        return this.buildContext;
    }

    private void processBuildContext(BuildContext buildContext) {
        if (!this.isProcessedAlready(buildContext)) {
            this.repositoryOccurences(buildContext);
            for (PlanRepositoryDefinition repositoryDefinition : buildContext.getVcsRepositories()) {
                this.fillVariablesForRepo(buildContext, repositoryDefinition);
            }
            Map variables = this.customVariableContext.getBuildInRepositoryVariablesIfBuildContext();
            Map customBuildData = buildContext.getBuildResult().getCustomBuildData();
            for (Map.Entry entry : variables.entrySet()) {
                String variableName = (String)entry.getKey();
                VariableDefinitionContext variableDefinitionContext = (VariableDefinitionContext)entry.getValue();
                customBuildData.put(variableName, variableDefinitionContext.getValue());
            }
        }
    }

    private boolean isProcessedAlready(BuildContext buildContext) {
        return buildContext.getBuildResult().getCustomBuildData().containsKey(REPOSITORY_NAME);
    }

    private void repositoryOccurences(BuildContext buildContext) {
        for (RepositoryDefinition repositoryDefinition : buildContext.getRepositoryDefinitions()) {
            String repoClass = repositoryDefinition.getPluginKey();
            Integer occurencesCnt = this.jobRepositoryOccurences.get(repoClass);
            if (occurencesCnt == null) {
                occurencesCnt = 0;
            }
            occurencesCnt = occurencesCnt + 1;
            this.jobRepositoryOccurences.put(repoClass, occurencesCnt);
        }
        this.changesetHasNoTriggeringRepositories = BambooIterables.stream((Iterable)buildContext.getBuildChanges().getRepositoryChanges()).noneMatch(BuildRepositoryChanges::isBuildTrigger);
    }

    private void fillVariablesForRepo(BuildContext buildContext, @NotNull PlanRepositoryDefinition repositoryDefinition) {
        if (repositoryDefinition.isLegacyRepository()) {
            Repository repository = repositoryDefinition.asLegacyData().getRepository();
            if (repository instanceof SvnRepository) {
                this.fillInSvnProperties(buildContext, repositoryDefinition, (SvnRepository)repository);
            } else if (repository instanceof PerforceRepository) {
                this.fillInPerforceProperties(buildContext, repositoryDefinition, (PerforceRepository)repository);
            } else if (repository instanceof CVSRepository) {
                this.fillInCvsProperties(buildContext, repositoryDefinition, (CVSRepository)repository);
            }
        }
        this.fillInGenericRepositoryProperties(buildContext, repositoryDefinition);
    }

    private void fillInGenericRepositoryProperties(BuildContext buildContext, @NotNull PlanRepositoryDefinition repositoryDefinition) {
        Map customBuildData = buildContext.getBuildResult().getCustomBuildData();
        customBuildData.put(this.addRepositoryId(repositoryDefinition, REPOSITORY_NAME), repositoryDefinition.getName());
        customBuildData.put(REPOSITORY_NAME, repositoryDefinition.getName());
        this.putRevisionNumber(buildContext, repositoryDefinition, REPOSITORY_REVISION_NUMBER);
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, REPOSITORY_PREVIOUS_REVISION_NUMBER, buildContext.getBuildChanges().getPreviousVcsRevisionKey(repositoryDefinition.getId()));
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey());
        if (moduleDescriptor != null && moduleDescriptor.providesCustomVariables()) {
            VcsVariableGenerator vcsVariableGenerator = moduleDescriptor.getVariableGenerator();
            LegacyVariableGenerator legacyVariableGenerator = (LegacyVariableGenerator)Narrow.downTo((Object)vcsVariableGenerator, LegacyVariableGenerator.class);
            if (legacyVariableGenerator == null) {
                String prefix = moduleDescriptor.getVariableGenerator().getLegacyPrefix();
                if (!StringUtils.isBlank((CharSequence)prefix)) {
                    for (Map.Entry entry : moduleDescriptor.getVariableGenerator().getPlanRepositoryVariables((VcsRepositoryData)repositoryDefinition).entrySet()) {
                        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, prefix + "." + (String)entry.getKey(), (String)entry.getValue());
                    }
                }
            } else {
                for (Map.Entry variable : legacyVariableGenerator.getLegacyCustomVariables((VcsRepositoryData)repositoryDefinition).entrySet()) {
                    this.addCustomDataIfNotNull(buildContext, repositoryDefinition, (String)variable.getKey(), (String)variable.getValue());
                }
            }
        }
        if (repositoryDefinition.getBranch() != null) {
            this.addCustomDataIfNotNull(buildContext, repositoryDefinition, REPOSITORY_BRANCH_NAME, repositoryDefinition.getBranch().getVcsBranch().getName());
        }
    }

    private void fillInSvnProperties(BuildContext buildContext, @NotNull PlanRepositoryDefinition repositoryDefinition, SvnRepository repository) {
        this.putRevisionNumber(buildContext, repositoryDefinition, SVN_REVISION_NUMBER);
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, SVN_USER_NAME, repository.getUsername());
    }

    private void fillInPerforceProperties(BuildContext buildContext, @NotNull PlanRepositoryDefinition repositoryDefinition, PerforceRepository repository) {
        this.putRevisionNumber(buildContext, repositoryDefinition, P4_REVISION_NUMBER);
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, P4_USER_NAME, repository.getUser());
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, P4_PORT, repository.getPort());
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, P4_CLIENT, repository.getClient());
    }

    private void fillInCvsProperties(BuildContext buildContext, @NotNull PlanRepositoryDefinition repositoryDefinition, CVSRepository repository) {
        this.putRevisionNumber(buildContext, repositoryDefinition, CVS_UPDATE_TIME);
        String latestRevision = buildContext.getBuildChanges().getVcsRevisionKey(repositoryDefinition.getId());
        if (latestRevision != null) {
            this.addCustomDataIfNotNull(buildContext, repositoryDefinition, CVS_UPDATE_TIME_LABEL, latestRevision.replaceAll("\\s", "_"));
        }
    }

    private void putRevisionNumber(BuildContext buildContext, @NotNull PlanRepositoryDefinition repositoryDefinition, String fieldName) {
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, fieldName, buildContext.getBuildChanges().getVcsRevisionKey(repositoryDefinition.getId()));
    }

    private void addCustomDataIfNotNull(BuildContext buildContext, @NotNull PlanRepositoryDefinition repositoryDefinition, String key, String value) {
        boolean shouldAdd;
        if (value == null) {
            return;
        }
        Map customBuildData = buildContext.getBuildResult().getCustomBuildData();
        customBuildData.put(this.addRepositoryIdIfNeeded(repositoryDefinition, key), value);
        customBuildData.put(this.addRepositoryId(repositoryDefinition, key), value);
        boolean bl = shouldAdd = this.changesetHasNoTriggeringRepositories || buildContext.getBuildChanges().getBuildRepositoryChanges(repositoryDefinition.getId()).isBuildTrigger();
        if (shouldAdd) {
            customBuildData.putIfAbsent(key, value);
        }
    }

    private String addRepositoryIdIfNeeded(@NotNull PlanRepositoryDefinition repositoryDefinition, String key) {
        if (this.jobRepositoryOccurences.get(repositoryDefinition.getPluginKey()) > 1) {
            return this.addRepositoryId(repositoryDefinition, key);
        }
        return key;
    }

    private String addRepositoryId(@NotNull PlanRepositoryDefinition repositoryDefinition, @NotNull String key) {
        String[] keyElements = StringUtils.split((String)key, (String)".", (int)2);
        return keyElements[0] + '.' + repositoryDefinition.getId() + (keyElements.length > 1 ? '.' + keyElements[1] : "");
    }

    @Nullable
    public ErrorCollection validate(BuildConfiguration buildConfiguration) {
        return null;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }
}

