/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.vcsversion;

import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.repository.BranchAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.cvsimpl.CVSRepository;
import com.atlassian.bamboo.repository.perforce.PerforceRepository;
import com.atlassian.bamboo.repository.svn.SvnRepository;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.repository.RepositoryV2;
import com.atlassian.bamboo.v2.build.task.AbstractBuildTask;
import com.atlassian.bamboo.variable.BuiltInVariableHelper;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.fugue.Iterables;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VCSVersionReader
extends AbstractBuildTask
implements CustomPreBuildAction {
    private static final Logger log = Logger.getLogger(VCSVersionReader.class);
    private static final String CUSTOM_SVN = "custom.svn";
    private static final String CUSTOM_CVS = "custom.cvs";
    private static final String CUSTOM_P4 = "custom.p4";
    private static final String REVISION_NUMBER = "revision.number";
    private static final String USER_NAME = "username";
    public static final String SVN_REVISION_NUMBER = "custom.svn.revision.number";
    public static final String SVN_LASTCHANGE_REVISION_NUMBER = "custom.svn.lastchange.revision.number";
    public static final String SVN_USER_NAME = "custom.svn.username";
    public static final String CVS_UPDATE_TIME = "custom.cvs.last.update.time";
    public static final String CVS_UPDATE_TIME_LABEL = "custom.cvs.last.update.time.label";
    public static final String P4_REVISION_NUMBER = "custom.p4.revision.number";
    public static final String P4_LASTCHANGE_REVISION_NUMBER = "custom.p4.lastchange.revision.number";
    public static final String P4_USER_NAME = "custom.p4.username";
    private static final String P4_PORT = "custom.p4.port";
    private static final String P4_CLIENT = "custom.p4.client";
    private static final String REPOSITORY_NAME = "repository.name";
    private static final String REPOSITORY_REVISION_NUMBER = "repository.revision.number";
    private static final String REPOSITORY_PREVIOUS_REVISION_NUMBER = "repository.previous.revision.number";
    private static final String REPOSITORY_BRANCH_NAME = "repository.branch.name";
    Map<Class<? extends Repository>, Integer> jobRepositoryOccurences = Maps.newHashMap();
    boolean changesetHasNoTriggeringRepositories = false;

    @NotNull
    public BuildContext call() throws Exception {
        this.processBuildContext(this.buildContext);
        this.processBuildContext(this.buildContext.getParentBuildContext());
        return this.buildContext;
    }

    private void processBuildContext(BuildContext buildContext) {
        if (!this.isProcessedAlready(buildContext)) {
            this.repositoryOccurences(buildContext);
            for (RepositoryDefinition repositoryDefinition : buildContext.getRepositoryDefinitions()) {
                this.fillVariablesForRepo(buildContext, repositoryDefinition);
            }
            HashMap variables = Maps.newHashMap();
            BuiltInVariableHelper.createRepositoryVariables((Map)variables, (List)buildContext.getRepositoryDefinitions(), (BuildChanges)buildContext.getBuildChanges(), (VariableType)VariableType.CUSTOM);
            for (String variableName : variables.keySet()) {
                buildContext.getBuildResult().getCustomBuildData().put(variableName, ((VariableDefinitionContext)variables.get(variableName)).getValue());
            }
        }
    }

    private boolean isProcessedAlready(BuildContext buildContext) {
        return buildContext.getBuildResult().getCustomBuildData().containsKey(REPOSITORY_NAME);
    }

    private void repositoryOccurences(BuildContext buildContext) {
        for (RepositoryDefinition repositoryDefinition : buildContext.getRepositoryDefinitions()) {
            Class<?> repoClass = repositoryDefinition.getRepository().getClass();
            Integer occurencesCnt = this.jobRepositoryOccurences.get(repoClass);
            if (occurencesCnt == null) {
                occurencesCnt = 0;
            }
            occurencesCnt = occurencesCnt + 1;
            this.jobRepositoryOccurences.put(repoClass, occurencesCnt);
        }
        this.changesetHasNoTriggeringRepositories = Iterables.findFirst((Iterable)buildContext.getBuildChanges().getRepositoryChanges(), (Predicate)new Predicate<BuildRepositoryChanges>(){

            public boolean apply(BuildRepositoryChanges input) {
                return input.isBuildTrigger();
            }
        }).isEmpty();
    }

    private void fillVariablesForRepo(BuildContext buildContext, @NotNull RepositoryDefinition repositoryDefinition) {
        Repository repository = repositoryDefinition.getRepository();
        if (repository instanceof SvnRepository) {
            this.fillInSvnProperties(buildContext, repositoryDefinition, (SvnRepository)repository);
        } else if (repository instanceof PerforceRepository) {
            this.fillInPerforceProperties(buildContext, repositoryDefinition, (PerforceRepository)repository);
        } else if (repository instanceof CVSRepository) {
            this.fillInCvsProperties(buildContext, repositoryDefinition, (CVSRepository)repository);
        }
        this.fillInGenericRepositoryProperties(buildContext, repositoryDefinition, (RepositoryV2)repository);
    }

    private void fillInGenericRepositoryProperties(BuildContext buildContext, @NotNull RepositoryDefinition repositoryDefinition, RepositoryV2 repository) {
        Map customBuildData = buildContext.getBuildResult().getCustomBuildData();
        customBuildData.put(this.addRepositoryId(repositoryDefinition, REPOSITORY_NAME), repositoryDefinition.getName());
        customBuildData.put(REPOSITORY_NAME, repositoryDefinition.getName());
        this.putRevisionNumber(buildContext, repositoryDefinition, REPOSITORY_REVISION_NUMBER);
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, REPOSITORY_PREVIOUS_REVISION_NUMBER, buildContext.getBuildChanges().getPreviousVcsRevisionKey(repositoryDefinition.getId()));
        if (repository instanceof CustomVariableProviderRepository) {
            CustomVariableProviderRepository variableProvider = (CustomVariableProviderRepository)repository;
            for (Map.Entry entry : variableProvider.getCustomVariables().entrySet()) {
                this.addCustomDataIfNotNull(buildContext, repositoryDefinition, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (repository instanceof BranchAwareRepository) {
            BranchAwareRepository branchAwareRepository = (BranchAwareRepository)repository;
            this.addCustomDataIfNotNull(buildContext, repositoryDefinition, REPOSITORY_BRANCH_NAME, branchAwareRepository.getVcsBranch().getName());
        }
    }

    private void fillInSvnProperties(BuildContext buildContext, @NotNull RepositoryDefinition repositoryDefinition, SvnRepository repository) {
        this.putRevisionNumber(buildContext, repositoryDefinition, SVN_REVISION_NUMBER);
        this.putLastChangeRevisionKey(buildContext, repositoryDefinition, SVN_LASTCHANGE_REVISION_NUMBER);
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, SVN_USER_NAME, repository.getUsername());
    }

    private void fillInPerforceProperties(BuildContext buildContext, @NotNull RepositoryDefinition repositoryDefinition, PerforceRepository repository) {
        this.putRevisionNumber(buildContext, repositoryDefinition, P4_REVISION_NUMBER);
        this.putLastChangeRevisionKey(buildContext, repositoryDefinition, P4_LASTCHANGE_REVISION_NUMBER);
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, P4_USER_NAME, repository.getUser());
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, P4_PORT, repository.getPort());
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, P4_CLIENT, repository.getClient());
    }

    private void fillInCvsProperties(BuildContext buildContext, @NotNull RepositoryDefinition repositoryDefinition, CVSRepository repository) {
        this.putRevisionNumber(buildContext, repositoryDefinition, CVS_UPDATE_TIME);
        String latestRevision = buildContext.getBuildChanges().getVcsRevisionKey(repositoryDefinition.getId());
        if (latestRevision != null) {
            this.addCustomDataIfNotNull(buildContext, repositoryDefinition, CVS_UPDATE_TIME_LABEL, latestRevision.replaceAll("\\s", "_"));
        }
    }

    private void putLastChangeRevisionKey(BuildContext buildContext, @NotNull RepositoryDefinition repositoryDefinition, String fieldName) {
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, fieldName, buildContext.getBuildChanges().getVcsLastChangeRevisionKey(repositoryDefinition.getId()));
    }

    private void putRevisionNumber(BuildContext buildContext, @NotNull RepositoryDefinition repositoryDefinition, String fieldName) {
        this.addCustomDataIfNotNull(buildContext, repositoryDefinition, fieldName, buildContext.getBuildChanges().getVcsRevisionKey(repositoryDefinition.getId()));
    }

    private void addCustomDataIfNotNull(BuildContext buildContext, @NotNull RepositoryDefinition repositoryDefinition, String key, String value) {
        Map customBuildData = buildContext.getBuildResult().getCustomBuildData();
        if (value != null) {
            boolean shouldAdd;
            customBuildData.put(this.addRepositoryIdIfNeeded(repositoryDefinition, key), value);
            customBuildData.put(this.addRepositoryId(repositoryDefinition, key), value);
            boolean bl = shouldAdd = this.changesetHasNoTriggeringRepositories || buildContext.getBuildChanges().getBuildRepositoryChanges(repositoryDefinition.getId()).isBuildTrigger();
            if (shouldAdd && !customBuildData.containsKey(key)) {
                customBuildData.put(key, value);
            }
        }
    }

    private String addRepositoryIdIfNeeded(@NotNull RepositoryDefinition repositoryDefinition, String key) {
        if (this.jobRepositoryOccurences.get(repositoryDefinition.getRepository().getClass()) > 1) {
            return this.addRepositoryId(repositoryDefinition, key);
        }
        return key;
    }

    private String addRepositoryId(@NotNull RepositoryDefinition repositoryDefinition, @NotNull String key) {
        String[] keyElements = StringUtils.split((String)key, (String)".", (int)2);
        return keyElements[0] + '.' + repositoryDefinition.getId() + (keyElements.length > 1 ? '.' + keyElements[1] : "");
    }

    @Nullable
    public ErrorCollection validate(BuildConfiguration buildConfiguration) {
        return null;
    }
}

