/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.php.task.utils;

import com.atlassian.bamboo.command.SimpleExecuteStreamHandler;
import com.google.common.base.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitUtils {
    private static final Logger log = Logger.getLogger(PhpUnitUtils.class);
    private static final long PHPUNIT_GET_VERSION_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final Pattern PHPUNIT_VERSION_PATTERN = Pattern.compile("PHPUnit (\\S+) by .*");

    private PhpUnitUtils() {
    }

    @Nullable
    public static String getPhpUnitVersion(@NotNull File phpUnitExecutable) {
        Commandline commandline = new Commandline();
        if (SystemUtils.IS_OS_WINDOWS) {
            commandline.setExecutable("cmd.exe");
            commandline.addArguments(new String[]{"/c", phpUnitExecutable.getPath()});
        } else {
            commandline.setExecutable(phpUnitExecutable.getPath());
        }
        commandline.addArguments(new String[]{"--version"});
        ArrayList phpUnitStdOut = new ArrayList();
        ArrayList phpUnitStdErr = new ArrayList();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(PHPUNIT_GET_VERSION_TIMEOUT);
        Execute execute = new Execute((ExecuteStreamHandler)new SimpleExecuteStreamHandler(phpUnitStdOut, phpUnitStdErr, "PhpVersion"), watchdog);
        execute.setWorkingDirectory(SystemUtils.getJavaIoTmpDir());
        execute.setCommandline(commandline.getCommandline());
        try {
            int exitValue = execute.execute();
            if (!Execute.isFailure((int)exitValue)) {
                for (String line : phpUnitStdOut) {
                    Matcher matcher = PHPUNIT_VERSION_PATTERN.matcher(line);
                    if (!matcher.matches()) continue;
                    return matcher.group(1);
                }
                log.warn((Object)("Failed to get PHPUnit version, unable to analyze output: \n" + StringUtils.join(phpUnitStdOut, (String)"\n")));
            } else if (watchdog.killedProcess()) {
                log.warn((Object)"Failed to get PHPUnit version, command timed out");
            } else {
                log.warn((Object)("Failed to get PHPUnit version, command failed: \n" + StringUtils.join(phpUnitStdErr, (String)"\n")));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to execute command", (Throwable)e);
        }
        return null;
    }

    public static class VersionMatcher
    implements Predicate<File> {
        private final Pattern pattern;

        public VersionMatcher(@NotNull Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean apply(@Nullable File input) {
            String version;
            if (input != null && (version = PhpUnitUtils.getPhpUnitVersion(input)) != null) {
                return this.pattern.matcher(version).matches();
            }
            return false;
        }
    }
}

