/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.vstest;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VSTestCapabilityDefaultsHelper
implements CapabilityDefaultsHelper {
    private static final Logger log = Logger.getLogger(VSTestCapabilityDefaultsHelper.class);
    private static final String SUPPORTED_FILE_TYPES = "Supported File Types:";
    private static final String DEFAULT_EXECUTOR_URI = "Default Executor Uri:";
    private static final String genericTestUri = "executor://generictestadapter/v1";
    private static final String msappContainerUri = "executor://msappcontainertestadapter/v1";
    private static final String mswpContainerUri = "executor://mswptestadapter/v1";
    private static final String orderedTestsUri = "executor://orderedtestadapter/v1";
    private static final String msTestUri = "executor://mstestadapter/v1";
    private static final String cppWpUri = "executor://cppwpunittestexecutor/v1";
    private static final String cppUri = "executor://cppunittestexecutor/v1";
    private static final String pesterUri = "executor://pestertestexecutor/v1";
    private static final String psateUri = "executor://psatetestexecutor/v1";
    private static final String pythonUri = "executor://pythontestexecutor/v1";
    private static final String nunitUri = "executor://nunittestexecutor/";
    private static final String gtestUri = "executor://googletestrunner/v1";
    private static final String mspecUri = "executor://machine.vstestadapter/";
    private static final String chutzpahUri = "executor://chutzpah-js/";
    private static final String typeScriptUri = "executor://typescriptexecutor/v1";
    private static final String xunitUri = "executor://xunit/VsTestRunner2";
    private static final String nodejsToolsUri = "executor://nodejstestexecutor/v1";
    private final Map<String, String> uriToFriendlyNames = new HashMap<String, String>();

    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySet) {
        if (SystemUtils.IS_OS_WINDOWS) {
            String vs2012Location = System.getenv("VS110COMNTOOLS");
            String vs2013Location = System.getenv("VS120COMNTOOLS");
            this.createCapabilityForVisualStudio("2012", capabilitySet, vs2012Location);
            this.createCapabilityForVisualStudio("2013", capabilitySet, vs2013Location);
        }
        return capabilitySet;
    }

    private void createCapabilityForVisualStudio(@NotNull String label, @NotNull CapabilitySet capabilitySet, @Nullable String path) {
        if (path == null) {
            return;
        }
        String key = "system.builder.vstestconsole.VSTest Console (VS " + label + ")";
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            File file = new File(new File(new File(path).getParentFile(), "IDE").getAbsolutePath(), "CommonExtensions");
            file = new File(file.getAbsolutePath(), "Microsoft");
            file = new File(file.getAbsolutePath(), "TestWindow");
            if ((file = new File(file.getAbsolutePath(), "vstest.console.exe")).exists() && file.isFile()) {
                CapabilityImpl capability = new CapabilityImpl(key, file.getAbsolutePath());
                capabilitySet.addCapability((Capability)capability);
                this.discoverTestDiscoverers(capabilitySet, label, file.getAbsolutePath());
            }
        }
    }

    private void discoverTestDiscoverers(@NotNull CapabilitySet capabilitySet, @NotNull String label, @NotNull String executablePath) {
        this.loadFriendlyMap();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ArrayList<String> args = new ArrayList<String>();
        args.add(executablePath);
        args.add("/UseVsixExtensions:true");
        args.add("/ListDiscoverers");
        processBuilder.command(args);
        Process process = null;
        try {
            process = processBuilder.start();
            process.waitFor();
        }
        catch (IOException exception) {
            log.debug((Object)"IOException caught trying to launch VSTest test discoverers.", (Throwable)exception);
            return;
        }
        catch (InterruptedException e) {
            log.debug((Object)"InterruptedException caught trying to launch VSTest test discoverers.", (Throwable)e);
            return;
        }
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(process.getInputStream()));){
            String prevLine = null;
            String adapterLine = null;
            String uriLine = null;
            String line = reader.readLine();
            while (line != null) {
                if (prevLine != null) {
                    if (line.contains(DEFAULT_EXECUTOR_URI)) {
                        adapterLine = prevLine.trim();
                        uriLine = line.substring(line.indexOf(DEFAULT_EXECUTOR_URI) + DEFAULT_EXECUTOR_URI.length()).trim();
                    } else if (line.contains(SUPPORTED_FILE_TYPES)) {
                        String extensionLine = line.trim();
                        String types = extensionLine.substring(extensionLine.indexOf(SUPPORTED_FILE_TYPES));
                        types = types.trim();
                        String friendlyName = this.uriToFriendlyNames.get(uriLine);
                        String name = friendlyName == null ? adapterLine : friendlyName;
                        String key = "system.vstestdiscoverer.VS " + label + "." + name;
                        if (capabilitySet.getCapability(key) == null) {
                            CapabilityImpl capability = new CapabilityImpl(key, types);
                            capabilitySet.addCapability((Capability)capability);
                        }
                    }
                }
                prevLine = line;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            log.debug((Object)"IOException caught trying to parse VSTest Test Discoverers List.", (Throwable)e);
        }
    }

    private void loadFriendlyMap() {
        if (this.uriToFriendlyNames.size() == 0) {
            this.uriToFriendlyNames.put(genericTestUri, "Generic Test Discoverer");
            this.uriToFriendlyNames.put(msappContainerUri, "MS App Container Discoverer");
            this.uriToFriendlyNames.put(mswpContainerUri, "MS Windows Phone Container Discoverer");
            this.uriToFriendlyNames.put(orderedTestsUri, "Ordered Test Discoverer");
            this.uriToFriendlyNames.put(msTestUri, "MS Test Discoverer");
            this.uriToFriendlyNames.put(cppWpUri, "MS C++ Windows Phone Test Discoverer");
            this.uriToFriendlyNames.put(cppUri, "MS C++ Test Discoverer");
            this.uriToFriendlyNames.put(pesterUri, "Pester PowerShell Test Discoverer");
            this.uriToFriendlyNames.put(psateUri, "Psate PowerShell Test Discoverer");
            this.uriToFriendlyNames.put(pythonUri, "Python Test Discoverer");
            this.uriToFriendlyNames.put(nunitUri, "NUnit Test Discoverer");
            this.uriToFriendlyNames.put(gtestUri, "Google C++ Test Discoverer");
            this.uriToFriendlyNames.put(mspecUri, "MSpec Test Discoverer");
            this.uriToFriendlyNames.put(chutzpahUri, "Chutzpah JavaScript Discoverer");
            this.uriToFriendlyNames.put(typeScriptUri, "TypeScript Test Discoverer");
            this.uriToFriendlyNames.put(xunitUri, "xUnit Test Discoverer");
            this.uriToFriendlyNames.put(nodejsToolsUri, "Node.js Tools Test Discoverer");
        }
    }
}

