/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.nunit;

import com.atlassian.bamboo.configuration.ConfigurationException;
import com.atlassian.bamboo.configuration.DefaultElementParser;
import com.atlassian.bamboo.configuration.ElementContentElementParser;
import com.atlassian.bamboo.configuration.ElementParser;
import com.atlassian.bamboo.plugin.dotnet.tests.TestResultContentHandler;
import com.atlassian.bamboo.plugin.dotnet.tests.TestResultsParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.security.xml.SecureXmlParserFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@NotThreadSafe
public class NUnitXmlTestResultsParser
extends TestResultContentHandler
implements TestResultsParser {
    private static final Logger log = Logger.getLogger(NUnitXmlTestResultsParser.class);
    private String suiteClassName;
    private TestResults currentTestResult;
    private TestCaseResultErrorImpl currentTestError;
    private List<TestResults> failedTests;
    private List<TestResults> passedTests;
    private List<TestResults> inconclusiveTests;
    private String systemOut;
    private String errorOut;

    @VisibleForTesting
    @NotNull
    static String getTestName(String fqTestName) {
        if (!fqTestName.contains(".")) {
            return fqTestName;
        }
        String fqNameWithoutParams = StringUtils.substringBefore((String)fqTestName, (String)"(");
        if (fqNameWithoutParams.endsWith(".")) {
            return fqNameWithoutParams;
        }
        return fqTestName.substring(fqNameWithoutParams.lastIndexOf(".") + 1);
    }

    public NUnitXmlTestResultsParser() {
        this.registerElementParser("categories", (ElementParser)new DefaultElementParser());
        this.registerElementParser("category", (ElementParser)new DefaultElementParser());
        this.registerElementParser("test-results", (ElementParser)new DefaultElementParser());
        this.registerElementParser("environment", (ElementParser)new DefaultElementParser());
        this.registerElementParser("culture-info", (ElementParser)new DefaultElementParser());
        this.registerElementParser("results", (ElementParser)new DefaultElementParser());
        this.registerElementParser("reason", (ElementParser)new DefaultElementParser());
        this.registerElementParser("message", (ElementParser)new MessageElementParser());
        this.registerElementParser("test-suite", (ElementParser)new TestSuiteElementParser());
        this.registerElementParser("stack-trace", (ElementParser)new DefaultElementParser());
        this.registerElementParser("test-case", (ElementParser)new TestCaseElementParser());
        this.registerElementParser("error", (ElementParser)new ErrorElementParser());
        this.registerElementParser("failure", (ElementParser)new FailureElementParser());
    }

    public int getNumberOfErrors() {
        return this.failedTests.size();
    }

    @Override
    public ImmutableList<TestResults> getSuccessfulTests() {
        return ImmutableList.copyOf(this.passedTests);
    }

    @Override
    public ImmutableList<TestResults> getFailedTests() {
        return ImmutableList.copyOf(this.failedTests);
    }

    @Override
    public ImmutableList<TestResults> getInconclusiveTests() {
        return ImmutableList.copyOf(this.inconclusiveTests);
    }

    public String getSystemOut() {
        return this.systemOut;
    }

    public String getSystemErr() {
        return this.errorOut;
    }

    @Override
    public void parse(InputStream inputStream) {
        this.failedTests = new ArrayList<TestResults>();
        this.passedTests = new ArrayList<TestResults>();
        this.inconclusiveTests = new ArrayList<TestResults>();
        try {
            XMLReader reader = SecureXmlParserFactory.newNamespaceAwareXmlReader();
            reader.setContentHandler(this);
            reader.parse(new InputSource(inputStream));
        }
        catch (Exception e) {
            log.error((Object)"Failed to parse xml test results.", (Throwable)e);
        }
    }

    public TestResults getCurrentTestResult() {
        return this.currentTestResult;
    }

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public void setCurrentTestResult(TestResults currentTestResult) {
        this.currentTestResult = currentTestResult;
    }

    public void setSuiteClassName(String suiteClassName) {
        this.suiteClassName = suiteClassName;
    }

    public String getErrorOut() {
        return this.errorOut;
    }

    public void setErrorOut(String errorOut) {
        this.errorOut = errorOut;
    }

    public void setSystemOut(String systemOut) {
        this.systemOut = systemOut;
    }

    public TestCaseResultErrorImpl getCurrentTestError() {
        return this.currentTestError;
    }

    public void setCurrentTestError(TestCaseResultErrorImpl currentTestError) {
        this.currentTestError = currentTestError;
    }

    public class FailureElementParser
    extends ElementContentElementParser {
        private String message;

        public void startElement(Attributes attributes) {
            super.startElement(attributes);
            this.message = attributes.getValue("message");
            NUnitXmlTestResultsParser.this.setCurrentTestError(new TestCaseResultErrorImpl(this.message));
        }

        public void endElement() throws ConfigurationException {
            super.endElement();
            if (NUnitXmlTestResultsParser.this.getCurrentTestResult() != null) {
                NUnitXmlTestResultsParser.this.getCurrentTestResult().addError((TestCaseResultError)NUnitXmlTestResultsParser.this.getCurrentTestError());
                NUnitXmlTestResultsParser.this.getCurrentTestResult().setState(TestState.FAILED);
                NUnitXmlTestResultsParser.this.setCurrentTestError(null);
            }
        }
    }

    public class ErrorElementParser
    extends ElementContentElementParser {
        public void endElement() throws ConfigurationException {
            super.endElement();
            TestCaseResultErrorImpl error = new TestCaseResultErrorImpl(this.getElementContent());
            if (NUnitXmlTestResultsParser.this.getCurrentTestResult() != null) {
                NUnitXmlTestResultsParser.this.getCurrentTestResult().addError((TestCaseResultError)error);
            } else {
                TestResults errorTestResult = new TestResults(NUnitXmlTestResultsParser.this.getSuiteClassName(), "unknownTestCase", Long.valueOf(0L));
                errorTestResult.addError((TestCaseResultError)error);
                NUnitXmlTestResultsParser.this.failedTests.add(errorTestResult);
            }
        }
    }

    public class TestCaseElementParser
    extends ElementContentElementParser {
        private static final String RESULT_PASSED_NUNIT2 = "SUCCESS";
        private static final String RESULT_PASSED = "PASSED";
        private static final String RESULT_INCONCLUSIVE = "INCONCLUSIVE";
        private static final String RESULT_SKIPPED = "SKIPPED";
        private static final String RESULT_FAILED = "FAILED";

        public void startElement(Attributes attributes) {
            super.startElement(attributes);
            double testDurationInMillis = NumberUtils.toDouble((String)attributes.getValue("time")) * 1000.0;
            String fqTestName = attributes.getValue("name");
            String className = this.getClassName(attributes, fqTestName);
            String testName = NUnitXmlTestResultsParser.getTestName(fqTestName);
            TestResults testResults = new TestResults(className != null ? className : NUnitXmlTestResultsParser.this.getSuiteClassName(), testName, Long.valueOf((long)testDurationInMillis));
            testResults.setState(this.getTestState(attributes));
            NUnitXmlTestResultsParser.this.setCurrentTestResult(testResults);
        }

        public void endElement() throws ConfigurationException {
            super.endElement();
            TestResults testResults = NUnitXmlTestResultsParser.this.getCurrentTestResult();
            if (testResults != null) {
                switch (testResults.getState()) {
                    case FAILED: {
                        NUnitXmlTestResultsParser.this.failedTests.add(testResults);
                        break;
                    }
                    case SKIPPED: {
                        NUnitXmlTestResultsParser.this.inconclusiveTests.add(testResults);
                        break;
                    }
                    case SUCCESS: {
                        NUnitXmlTestResultsParser.this.passedTests.add(testResults);
                    }
                }
                NUnitXmlTestResultsParser.this.setCurrentTestResult(null);
            }
        }

        private TestState getTestState(Attributes attributes) {
            String result = attributes.getValue("result");
            if (result != null) {
                switch (result.toUpperCase()) {
                    case "PASSED": 
                    case "SUCCESS": {
                        return TestState.SUCCESS;
                    }
                    case "FAILED": {
                        return TestState.FAILED;
                    }
                }
                return TestState.SKIPPED;
            }
            boolean executed = Boolean.parseBoolean(attributes.getValue("executed"));
            boolean success = Boolean.parseBoolean(attributes.getValue("success"));
            if (executed) {
                return success ? TestState.SUCCESS : TestState.FAILED;
            }
            return TestState.SKIPPED;
        }

        private String getClassName(Attributes attributes, String fqTestName) {
            String className = attributes.getValue("classname");
            String fqNameWithoutParams = StringUtils.substringBefore((String)fqTestName, (String)"(");
            if (className == null && fqNameWithoutParams.contains(".")) {
                if (fqNameWithoutParams.endsWith(".")) {
                    return null;
                }
                return StringUtils.substringBeforeLast((String)fqNameWithoutParams, (String)".");
            }
            return className;
        }
    }

    public class TestSuiteElementParser
    extends ElementContentElementParser {
        public void startElement(Attributes attributes) {
            super.startElement(attributes);
            NUnitXmlTestResultsParser.this.setSuiteClassName(attributes.getValue("name"));
        }
    }

    public class MessageElementParser
    extends ElementContentElementParser {
        public void endElement() throws ConfigurationException {
            super.endElement();
            if (NUnitXmlTestResultsParser.this.getCurrentTestError() != null) {
                StringBuilder builder = new StringBuilder();
                if (NUnitXmlTestResultsParser.this.getCurrentTestError().getContent() != null) {
                    builder.append(NUnitXmlTestResultsParser.this.getCurrentTestError().getContent());
                    builder.append(System.getProperty("line.separator"));
                }
                builder.append(this.getElementContent());
                NUnitXmlTestResultsParser.this.setCurrentTestError(new TestCaseResultErrorImpl(builder.toString()));
            }
        }
    }
}

