/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.nunit;

import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.builders.task.NUnitRunnerTask;
import com.atlassian.bamboo.specs.model.task.NUnitRunnerTaskProperties;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class NUnitRunnerTaskExporter
implements TaskDefinitionExporter {
    private static final ValidationContext NUNIT_PARSER_CONTEXT = ValidationContext.of((String)"NUnit runner task");
    @Autowired
    private UIConfigSupport uiConfigSupport;

    @NotNull
    public NUnitRunnerTask toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        Map configuration = taskDefinition.getConfiguration();
        return NUnitRunnerTaskExporter.getTaskForCapabilityKey((String)configuration.get("label")).nUnitTestFiles((String)configuration.get("nunitTestFiles")).resultFilename((String)configuration.get("nunitResultsFile")).testsToRun(configuration.getOrDefault("run", "").split(",")).testCategoriesToInclude(configuration.getOrDefault("include", "").split(",")).testCategoriesToExclude(configuration.getOrDefault("exclude", "").split(",")).commandLineOptions((String)configuration.get("commandLineOptions")).environmentVariables((String)configuration.get("environmentVariables"));
    }

    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, TaskProperties taskProperties) {
        NUnitRunnerTaskProperties properties = (NUnitRunnerTaskProperties)Narrow.downTo((Object)taskProperties, NUnitRunnerTaskProperties.class);
        if (properties != null) {
            HashMap<String, String> cfg = new HashMap<String, String>();
            NUnitRunnerTask.NUnitVersion nUnitVersion = properties.getNUnitVersion();
            cfg.put("label", NUnitRunnerTaskExporter.getCapabilityKey(properties.getExecutable(), nUnitVersion));
            cfg.put("nunitTestFiles", properties.getNUnitTestFiles());
            cfg.put("nunitResultsFile", properties.getResultFilename());
            if (!properties.getTestsToRun().isEmpty()) {
                cfg.put("run", properties.getTestsToRun().stream().collect(Collectors.joining(",")));
            }
            if (!properties.getTestCategoriesToInclude().isEmpty()) {
                cfg.put("include", properties.getTestCategoriesToInclude().stream().collect(Collectors.joining(",")));
            }
            if (!properties.getTestCategoriesToExclude().isEmpty()) {
                cfg.put("exclude", properties.getTestCategoriesToExclude().stream().collect(Collectors.joining(",")));
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getCommandLineOptions())) {
                cfg.put("commandLineOptions", properties.getCommandLineOptions());
            }
            if (StringUtils.isNotBlank((CharSequence)properties.getEnvironmentVariables())) {
                cfg.put("environmentVariables", properties.getEnvironmentVariables());
            }
            return cfg;
        }
        throw new IllegalStateException("Don't know how to import task properties of type: " + taskProperties.getClass().getName());
    }

    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        ArrayList<ValidationProblem> result = new ArrayList<ValidationProblem>();
        NUnitRunnerTaskProperties properties = (NUnitRunnerTaskProperties)Narrow.downTo((Object)taskProperties, NUnitRunnerTaskProperties.class);
        if (properties != null) {
            String capabilityPrefix = NUnitRunnerTaskExporter.getCapabilityShortKey(properties.getNUnitVersion());
            List labels = this.uiConfigSupport.getExecutableLabels(capabilityPrefix);
            String label = properties.getExecutable();
            if (labels == null || !labels.contains(label)) {
                result.add(new ValidationProblem(NUNIT_PARSER_CONTEXT, String.format("Can't find executable by label: '%s'. Available values: %s", label, labels)));
            }
        }
        return result;
    }

    @NotNull
    private static NUnitRunnerTask getTaskForCapabilityKey(@NotNull String key) {
        NUnitRunnerTask task = new NUnitRunnerTask();
        if (key.startsWith("system.builder.nunit3")) {
            return task.executable(key.substring("system.builder.nunit3".length() + 1)).nUnitVersion3();
        }
        if (key.startsWith("system.builder.nunit")) {
            return task.executable(key.substring("system.builder.nunit".length() + 1)).nUnitVersion2();
        }
        return task.executable(key).nUnitVersion2();
    }

    @NotNull
    private static String getCapabilityKey(String capabilityLabel, NUnitRunnerTask.NUnitVersion nUnitVersion) {
        return Joiner.on((String)".").join((Object)"system.builder", (Object)NUnitRunnerTaskExporter.getCapabilityShortKey(nUnitVersion), new Object[]{capabilityLabel});
    }

    @NotNull
    private static String getCapabilityShortKey(NUnitRunnerTask.NUnitVersion nUnitVersion) {
        switch (nUnitVersion) {
            case NUNIT_2: {
                return "nunit";
            }
            case NUNIT_3: {
                return "nunit3";
            }
        }
        throw new IllegalStateException("Unsupported enum value: " + nUnitVersion);
    }
}

