/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.ncover;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.plugin.dotnet.ncover.NCoverCoverageInformation;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.util.NumberUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ViewNCoverBuildResults
extends ViewBuildResults {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ViewNCoverBuildResults.class);
    private Collection<NCoverCoverageInformation> coverageChanges = new ArrayList<NCoverCoverageInformation>();

    public String execute() throws Exception {
        String superResult = super.execute();
        if ("error".equals(superResult)) {
            return "error";
        }
        this.populateCoverageChanges(this.getBuildResultsSummary());
        return superResult;
    }

    private void populateCoverageChanges(BuildResultsSummary buildResultsSummary) {
        String csv = (String)buildResultsSummary.getCustomBuildData().get("NCOVER_COVERAGE_CHANGES");
        if (StringUtils.isNotEmpty((CharSequence)csv)) {
            BufferedReader reader = new BufferedReader(new StringReader(csv));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(line, ",");
                    String className = tokenizer.nextToken();
                    Double lineRate = NumberUtils.unlocalizedStringToDouble((String)tokenizer.nextToken());
                    Double delta = NumberUtils.unlocalizedStringToDouble((String)tokenizer.nextToken());
                    this.coverageChanges.add(new NCoverCoverageInformation(className, lineRate, delta));
                }
            }
            catch (IOException | NumberFormatException e) {
                log.error((Object)e);
            }
        }
    }

    public Collection getCoverageChanges() {
        return this.coverageChanges;
    }
}

