/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.ncover;

import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.plugin.dotnet.ncover.NCoverReportParser;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.FileVisitor;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BaseConfigurableBuildPlugin;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class NCoverBuildProcessor
extends BaseConfigurableBuildPlugin
implements CustomBuildProcessor {
    private static final Logger log = Logger.getLogger(NCoverBuildProcessor.class);
    private static final String NCOVER_PATH = "custom.ncover.path";
    public static final String NCOVER_EXISTS = "custom.ncover.exists";
    public static final String NCOVER_XML_PATH_KEY = "custom.ncover.path";
    public static final String NCOVER_LINE_COVERAGE = "NCOVER_LINE_COVERAGE";
    public static final String NCOVER_ASSEMBLIES = "NCOVER_ASSEMBLIES";
    public static final String NCOVER_LOC = "NCOVER_LOC";
    public static final String NCOVER_LE = "NCOVER_LE";
    public static final String NCOVER_LNE = "NCOVER_LNE";
    public static final String NCOVER_COVERAGE_DELTA = "NCOVER_COVERAGE_DELTA";
    public static final String NCOVER_RESULT_CONTENTS = "NCOVER_RESULT_CONTENTS";
    public static final String NCOVER_METHODS = "NCOVER_METHODS";
    public static final String NCOVER_CLASSES = "NCOVER_CLASSES";
    public static final String NCOVER_COVERAGE_CHANGES = "NCOVER_COVERAGE_CHANGES";
    public static final String NCOVER_LINE_RATE = "NCOVER_LINE_RATE";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    @Inject
    private BuildDirectoryManager buildDirectoryManager;
    public static final String BUILD_NUMBER = "buildNumber";
    public static final String BUILD_KEY = "buildKey";
    public static final String NCOVER_POSTBUILD_XMPP = "custom.bamboo.ncover.postbuild.xmpp";
    public static final String NCOVER_POSTBUILD_THRESHOLD = "threshold";
    public static final String NCOVER_POSTBUILD_EMAIL = "custom.bamboo.ncover.postbuild.email";
    public static final String NCOVER_POSTBUILD = "custom.bamboo.ncover.postbuild";

    public ErrorCollection validate(BuildConfiguration configuration) {
        SimpleErrorCollection ec = new SimpleErrorCollection();
        if (configuration.getBoolean(NCOVER_EXISTS) && StringUtils.isBlank((CharSequence)configuration.getString("custom.ncover.path"))) {
            ec.addError("custom.ncover.path", "Please specify the directory containing the XML NCover output files.");
        }
        return ec;
    }

    public BuildContext call() throws InterruptedException, Exception {
        String pathPattern;
        Map customConfiguration;
        log.info((Object)"inside NCoverBuildProcessor.call()");
        HashMap ncoverResults = new HashMap();
        CurrentBuildResult buildResult = this.buildContext.getBuildResult();
        if (buildResult != null && Boolean.parseBoolean((String)(customConfiguration = this.buildContext.getBuildDefinition().getCustomConfiguration()).get(NCOVER_EXISTS)) && customConfiguration.containsKey("custom.ncover.path") && !StringUtils.isEmpty((CharSequence)(pathPattern = (String)customConfiguration.get("custom.ncover.path")))) {
            File planSourceDirectory = BuildContextHelper.getBuildWorkingDirectory((CommonContext)this.buildContext);
            NCoverCoverageFileVisitor fileVisitor = new NCoverCoverageFileVisitor(planSourceDirectory, ncoverResults);
            log.info((Object)("Running NCover Build Processor over source dir:" + planSourceDirectory.getAbsolutePath() + " path pattern: " + pathPattern));
            fileVisitor.visitFilesThatMatch(pathPattern);
            if (ncoverResults.isEmpty()) {
                log.error((Object)("Could not find any NCover results in source dir:" + planSourceDirectory.getAbsolutePath() + " path pattern: " + pathPattern));
            } else {
                buildResult.getCustomBuildData().putAll(ncoverResults);
            }
        }
        return this.buildContext;
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return ImmutableSet.of((Object)"custom.ncover.path", (Object)NCOVER_EXISTS);
    }

    public boolean isConfigurationMissing(@NotNull HierarchicalConfiguration configuration) {
        return !configuration.containsKey(NCOVER_EXISTS);
    }

    public BuildDirectoryManager getBuildDirectoryManager() {
        return this.buildDirectoryManager;
    }

    public void setBuildDirectoryManager(BuildDirectoryManager buildDirectoryManager) {
        this.buildDirectoryManager = buildDirectoryManager;
    }

    private final class NCoverCoverageFileVisitor
    extends FileVisitor {
        private final Map<String, String> results;

        private NCoverCoverageFileVisitor(File file, Map<String, String> results) {
            super(file);
            this.results = results;
        }

        public void visitFile(File file) {
            if (file.getName().endsWith("xml")) {
                this.runParse(file);
            }
        }

        private void runParse(File file) {
            try {
                log.info((Object)("Parsing file: " + file.getAbsolutePath()));
                NCoverReportParser parser = new NCoverReportParser();
                parser.parse(file);
                this.storeResultsFromParser(parser);
            }
            catch (Exception e) {
                log.error((Object)("Failed to parse artifact result file \"" + file.getName() + "\""), (Throwable)e);
            }
        }

        private void storeResultsFromParser(NCoverReportParser parser) {
            double coverage = NumberUtils.round((double)(parser.getLineRate() * 100.0), (int)4);
            NumberFormat defaultFormat = NumberFormat.getInstance();
            this.appendResults(NCoverBuildProcessor.NCOVER_RESULT_CONTENTS, parser.getCsv());
            this.appendDoubleResults(NCoverBuildProcessor.NCOVER_LINE_RATE, defaultFormat.format(coverage));
            this.appendLongResults(NCoverBuildProcessor.NCOVER_METHODS, Long.toString(parser.getMethods()));
            this.appendLongResults(NCoverBuildProcessor.NCOVER_CLASSES, Long.toString(parser.getClasses()));
            this.appendLongResults(NCoverBuildProcessor.NCOVER_ASSEMBLIES, Long.toString(parser.getAssemblies()));
            this.appendLongResults(NCoverBuildProcessor.NCOVER_LOC, Long.toString(parser.getLinesOfCode()));
            this.appendLongResults(NCoverBuildProcessor.NCOVER_LE, Long.toString(parser.getLinesExecuted()));
            this.appendLongResults(NCoverBuildProcessor.NCOVER_LNE, Long.toString(parser.getLinesNotExecuted()));
        }

        private void appendResults(String key, String results) {
            log.debug((Object)("Appending " + results + " to " + key));
            String existingResults = this.results.get(key);
            if (existingResults == null) {
                existingResults = "";
            }
            if (results == null) {
                results = "";
            }
            String newValue = existingResults + results;
            this.results.put(key, newValue);
        }

        private void appendLongResults(String key, String results) {
            log.debug((Object)("Appending " + results + " to " + key));
            String existingResults = this.results.get(key);
            if (existingResults == null || existingResults.equals("")) {
                existingResults = Long.toString(0L);
            }
            if (results == null || results.equals("")) {
                results = Long.toString(0L);
            }
            Long newValue = NumberUtils.stringToLong((String)existingResults) + NumberUtils.stringToLong((String)results);
            NumberFormat defaultFormat = NumberFormat.getInstance();
            this.results.put(key, defaultFormat.format(newValue));
        }

        private void appendDoubleResults(String key, String results) {
            log.debug((Object)("Appending " + results + " to " + key));
            boolean storeAverage = true;
            String existingResults = this.results.get(key);
            if (existingResults == null || existingResults.equals("")) {
                existingResults = Double.toString(0.0);
                storeAverage = false;
            }
            if (results == null || results.equals("")) {
                results = Double.toString(0.0);
            }
            Double newValue = NumberUtils.unlocalizedStringToDouble((String)existingResults) + NumberUtils.unlocalizedStringToDouble((String)results);
            if (storeAverage) {
                newValue = newValue / 2.0;
            }
            NumberFormat defaultFormat = NumberFormat.getInstance();
            this.results.put(key, defaultFormat.format(newValue));
        }
    }
}

