/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.nant;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.deployments.environments.DeploymentTaskRequirementSupport;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.plugin.dotnet.support.AbstractDotNetTaskConfigurator;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NantConfigurator
extends AbstractDotNetTaskConfigurator
implements BuildTaskRequirementSupport,
DeploymentTaskRequirementSupport {
    private static final Set<String> FIELDS_TO_COPY = Sets.newHashSet((Object[])new String[]{"label", "buildFile", "target", "options", "environmentVariables", "workingSubDirectory"});
    private static final String DEFAULT_TARGET = "run";
    private static final String DEFAULT_BUILD_FILE = "default.build";

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Environment environment) {
        String label = (String)taskDefinition.getConfiguration().get("label");
        return Sets.newHashSet((Object[])new Requirement[]{new RequirementImpl("system.builder.nant." + label, true, ".*")});
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job buildable) {
        String label = (String)taskDefinition.getConfiguration().get("label");
        return Sets.newHashSet((Object[])new Requirement[]{new RequirementImpl("system.builder.nant." + label, true, ".*")});
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @NotNull ErrorCollection errorCollection) {
        String label;
        String target = actionParametersMap.getString("target");
        if (StringUtils.isEmpty((CharSequence)target)) {
            errorCollection.addError("target", this.textProvider.getText("nant.target.error"));
        }
        if (StringUtils.isEmpty((CharSequence)(label = actionParametersMap.getString("label")))) {
            errorCollection.addError("label", this.textProvider.getText("nant.label.error"));
        }
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("target", DEFAULT_TARGET);
        context.put("buildFile", DEFAULT_BUILD_FILE);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map map = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(map, params, FIELDS_TO_COPY);
        return map;
    }
}

