/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests.vstest;

import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.v2.build.agent.capability.AbstractCapabilityTypeModule;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.struts.TextProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class VSTestDiscoverCapabilityTypeModule
extends AbstractCapabilityTypeModule {
    private static final Logger log = Logger.getLogger(VSTestDiscoverCapabilityTypeModule.class);
    static final String VSTEST_CAPABILITY_NAME = "vstestdiscoverer";
    static final String VSTEST_CAPABILITY_PREFIX = "system.vstestdiscoverer";
    private TextProvider textProvider;

    @Autowired
    public VSTestDiscoverCapabilityTypeModule(TemplateRenderer templateRenderer, TextProvider textProvider) {
        this.setTemplateRenderer(templateRenderer);
        this.textProvider = textProvider;
    }

    @NotNull
    public Map<String, String> validate(@NotNull Map<String, String[]> params) {
        HashMap<String, String> fieldErrors = new HashMap<String, String>();
        String name = params.get("name")[0];
        if (StringUtils.isBlank((CharSequence)name)) {
            fieldErrors.put("name", this.textProvider.getText("agent.capability.type.system.vstestdiscoverer.error.emptyName"));
        } else {
            BambooFieldValidate.checkFieldXssSafety(fieldErrors, (com.opensymphony.xwork2.TextProvider)this.textProvider, (String)"name", (String)name);
        }
        return fieldErrors;
    }

    @NotNull
    public Capability getCapability(@NotNull Map<String, String[]> params) {
        String name = params.get("name")[0];
        String supportedFileTypes = params.get("supportedFileTypes")[0];
        return new CapabilityImpl("system.vstestdiscoverer." + name, supportedFileTypes);
    }

    @NotNull
    public String getLabel(@NotNull String key) {
        return VSTestDiscoverCapabilityTypeModule.constructLabel(key);
    }

    public static String constructLabel(@NotNull String key) {
        Object[] strings = key.split("\\.", 0);
        if (strings.length > 4) {
            key = strings[2] + " " + StringUtils.join((Object[])strings, (String)".", (int)3, (int)strings.length);
        } else if (strings.length == 4) {
            key = strings[2] + " " + (String)strings[3];
        } else {
            log.warn((Object)("Key: '" + key + "' cannot be parsed. Returning full key"));
        }
        return key;
    }

    private static interface Configuration {
        public static final String NAME = "name";
        public static final String SUPPORTED_FILE_TYPES = "supportedFileTypes";
    }
}

