/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.plugin.dotnet.tests.TestReportCollectorImpl;
import com.atlassian.bamboo.plugin.dotnet.tests.TestResultsParser;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.utils.FileVisitor;
import java.io.File;
import java.util.Set;
import org.apache.log4j.Logger;

public class TestResultFileVisitor
extends FileVisitor {
    private static final Logger log = Logger.getLogger(TestResultFileVisitor.class);
    int[] numberOfFilesFound;
    Set<TestResults> failedTestResults;
    Set<TestResults> successfulTestResults;
    private TestResultsParser parser;

    protected TestResultFileVisitor(File file) {
        super(file);
    }

    protected TestResultFileVisitor(File file, int[] numberOfFilesFound, Set<TestResults> failedTestResults, Set<TestResults> successfulTestResults, TestResultsParser parser) {
        this(file);
        this.numberOfFilesFound = numberOfFilesFound;
        this.failedTestResults = failedTestResults;
        this.successfulTestResults = successfulTestResults;
        this.parser = parser;
    }

    public void visitFile(File file) {
        log.debug((Object)("Processing file: " + file.getAbsolutePath()));
        if (file.getName().endsWith("xml") || file.getName().endsWith("trx")) {
            try {
                log.info((Object)("Running parse on file: " + file.getName()));
                this.numberOfFilesFound[0] = this.numberOfFilesFound[0] + 1;
                TestReportCollectorImpl testReportCollector = new TestReportCollectorImpl(this.parser);
                TestCollectionResult result = testReportCollector.collect(file);
                this.failedTestResults.addAll(result.getFailedTestResults());
                this.successfulTestResults.addAll(result.getSuccessfulTestResults());
            }
            catch (Exception e) {
                log.error((Object)("Failed to parse test result files \"" + file.getName() + "\""), (Throwable)e);
            }
        }
    }
}

