/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.tests;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.plugin.dotnet.tests.TestResultsParser;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class TestReportCollectorImpl
implements TestReportCollector {
    private TestResultsParser parser;

    public TestReportCollectorImpl(TestResultsParser parser) {
        this.parser = parser;
    }

    @NotNull
    public TestCollectionResult collect(@NotNull File file) throws Exception {
        TestCollectionResult testCollectionResult;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.parser.parse(inputStream);
            testCollectionResult = new TestCollectionResultBuilder().addSuccessfulTestResults(this.parser.getSuccessfulTests()).addFailedTestResults(this.parser.getFailedTests()).addSkippedTestResults(this.parser.getInconclusiveTests()).build();
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return testCollectionResult;
    }

    @NotNull
    public Set<String> getSupportedFileExtensions() {
        return Sets.newHashSet((Object[])new String[]{"trx", "xml"});
    }
}

