/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.ncover;

import com.atlassian.bamboo.build.CustomBuildProcessorServer;
import com.atlassian.bamboo.plugin.dotnet.ncover.NCoverCoverageInformation;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.v2.build.BaseConfigurableBuildPlugin;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class NCoverBuildProcessorServer
extends BaseConfigurableBuildPlugin
implements CustomBuildProcessorServer {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger log = Logger.getLogger(NCoverBuildProcessorServer.class);
    private ResultsSummaryManager resultsSummaryManager;

    @NotNull
    public BuildContext call() throws InterruptedException {
        CurrentBuildResult buildResult = this.buildContext.getBuildResult();
        Map customConfiguration = this.buildContext.getBuildDefinition().getCustomConfiguration();
        if (Boolean.parseBoolean((String)customConfiguration.get("custom.ncover.exists"))) {
            this.calculateDelta(buildResult.getCustomBuildData());
        }
        return this.buildContext;
    }

    private void calculateDelta(Map<String, String> results) {
        try {
            ResultsSummary previousSummary = this.resultsSummaryManager.getLastSuccessfulResultSummary(this.buildContext.getPlanResultKey().getPlanKey());
            if (previousSummary != null && previousSummary.getCustomBuildData() != null && previousSummary.getCustomBuildData().containsKey("NCOVER_LINE_RATE")) {
                String lineRate;
                String prevCoverStr = (String)previousSummary.getCustomBuildData().get("NCOVER_LINE_RATE");
                if (!prevCoverStr.equals(lineRate = results.get("NCOVER_LINE_RATE"))) {
                    this.runCoverageChangeComparison(previousSummary, results);
                }
                double prevCoverDbl = NumberUtils.stringToDouble((String)prevCoverStr);
                double coverage = NumberUtils.stringToDouble((String)lineRate);
                results.put("NCOVER_COVERAGE_DELTA", Double.toString(coverage - prevCoverDbl));
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)e);
        }
    }

    private void runCoverageChangeComparison(ResultsSummary previousSummary, Map<String, String> results) {
        ArrayList<NCoverCoverageInformation> coverageInfoList = new ArrayList<NCoverCoverageInformation>();
        ArrayList<NCoverCoverageInformation> coverageChangeList = new ArrayList<NCoverCoverageInformation>();
        Map<String, String> currentMap = this.buildClassCoverageMap(results.get("NCOVER_RESULT_CONTENTS"));
        String previousCsv = (String)previousSummary.getCustomBuildData().get("NCOVER_RESULT_CONTENTS");
        if (previousCsv == null || StringUtils.isEmpty((CharSequence)previousCsv)) {
            return;
        }
        Map<String, String> previousMap = this.buildClassCoverageMap(previousCsv);
        Iterator<String> iterator = currentMap.keySet().iterator();
        while (iterator.hasNext()) {
            Double difference;
            String o;
            String className = o = iterator.next();
            String lineRate = currentMap.get(className);
            String oldLineRate = previousMap.get(className);
            if (StringUtils.isEmpty((CharSequence)lineRate) || StringUtils.isEmpty((CharSequence)oldLineRate) || (difference = Double.valueOf(NumberUtils.stringToDouble((String)lineRate) - NumberUtils.stringToDouble((String)oldLineRate))).equals(0.0)) continue;
            coverageInfoList.add(new NCoverCoverageInformation(className, NumberUtils.stringToDouble((String)lineRate), difference));
        }
        if (coverageInfoList.isEmpty()) {
            log.info((Object)"No differences in coverage found");
        } else {
            Collections.sort(coverageInfoList);
            int size = Math.min(coverageInfoList.size(), 10);
            for (int i = 0; i < size; ++i) {
                coverageChangeList.add((NCoverCoverageInformation)coverageInfoList.get(i));
            }
            results.put("NCOVER_COVERAGE_CHANGES", this.convertToCsv(coverageChangeList));
        }
    }

    private String convertToCsv(List<NCoverCoverageInformation> coverageChangeList) {
        StringBuffer buffer = new StringBuffer();
        for (NCoverCoverageInformation information : coverageChangeList) {
            buffer.append(information.getClassName()).append(",");
            buffer.append(information.getLineRate()).append(",");
            buffer.append(information.getDelta());
            buffer.append(LINE_SEPARATOR);
        }
        return buffer.toString();
    }

    private Map<String, String> buildClassCoverageMap(String csv) {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new StringReader(csv));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                StringTokenizer token = new StringTokenizer(line, ",");
                String className = token.nextToken();
                String lineRate = token.nextToken();
                map.put(className, lineRate);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error parsing csv", (Throwable)e);
        }
        return map;
    }

    ResultsSummaryManager getResultsSummaryManager() {
        return this.resultsSummaryManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

