/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.nant;

import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ExecutablePathUtils;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class NantCapabilityDefaultsHelper
implements CapabilityDefaultsHelper {
    private static final Logger log = Logger.getLogger(NantCapabilityDefaultsHelper.class);
    private static final String EXECUTABLE_NAME = SystemUtils.IS_OS_WINDOWS ? "nant.exe" : "nant";
    private static final String NANT_LABEL = "Nant";

    @NotNull
    public CapabilitySet addDefaultCapabilities(@NotNull CapabilitySet capabilitySet) {
        File file;
        String executablePath = ExecutablePathUtils.findExecutablePath((String)EXECUTABLE_NAME);
        if (StringUtils.isNotEmpty((CharSequence)executablePath) && (file = new File(executablePath)).exists() && file.isFile()) {
            File home = ExecutablePathUtils.getHomeFromExecutableInHomeBin((File)file);
            if (home != null && home.isDirectory()) {
                CapabilityImpl capability = new CapabilityImpl("system.builder.nant.Nant", home.getAbsolutePath());
                capabilitySet.addCapability((Capability)capability);
            } else {
                log.error((Object)("Found NAnt executable at '" + executablePath + "' but could not get the home directory from the path"));
            }
        }
        return capabilitySet;
    }
}

