/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.msbuild;

import com.atlassian.bamboo.utils.BambooOptionals;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.Win32Exception;
import io.atlassian.util.concurrent.Lazy;
import java.io.File;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class WindowsSystemPaths {
    private static final Logger log = Logger.getLogger(WindowsSystemPaths.class);
    static final Supplier<Optional<File>> PROGRAM_FILES = Lazy.supplier(() -> WindowsSystemPaths.getFolderPath(38, "%PROGRAMFILES%"));
    static final Supplier<Optional<File>> PROGRAM_FILES_X86 = Lazy.supplier(() -> WindowsSystemPaths.getFolderPath(42, "%PROGRAMFILES(X86)%"));
    static final Supplier<Optional<File>> WINDOWS = Lazy.supplier(() -> WindowsSystemPaths.getFolderPath(36, "%WINDIR%"));

    private WindowsSystemPaths() {
    }

    public static Collection<File> getProgramFilesDirectories() {
        return Stream.of(PROGRAM_FILES, PROGRAM_FILES_X86).map(Supplier::get).flatMap(BambooOptionals::stream).collect(Collectors.toList());
    }

    private static Optional<File> getFolderPath(int csidl, String dirName) {
        try {
            String folderPath = Shell32Util.getFolderPath(csidl);
            if (StringUtils.isEmpty((CharSequence)folderPath)) {
                return Optional.empty();
            }
            File file = new File(folderPath);
            if (file.isDirectory()) {
                return Optional.of(file);
            }
            log.warn((Object)(dirName + " is not a directory"));
            return Optional.empty();
        }
        catch (Win32Exception e) {
            log.warn((Object)("Could not find the " + dirName + " directory"), (Throwable)e);
            return Optional.empty();
        }
    }
}

