/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin.dotnet.msbuild;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.deployments.environments.DeploymentTaskRequirementSupport;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.plugin.dotnet.support.AbstractDotNetTaskConfigurator;
import com.atlassian.bamboo.task.BuildTaskRequirementSupport;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsBuildConfigurator
extends AbstractDotNetTaskConfigurator
implements BuildTaskRequirementSupport,
DeploymentTaskRequirementSupport {
    private static final Logger log = Logger.getLogger(MsBuildConfigurator.class);
    private static final Set<String> FIELDS_TO_COPY = Sets.newHashSet((Object[])new String[]{"label", "solution", "options", "environmentVariables", "workingSubDirectory"});
    private static final String DEFAULT_SOLUTION = "YourSolution.sln";

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Environment environment) {
        String label = (String)taskDefinition.getConfiguration().get("label");
        return Sets.newHashSet((Object[])new Requirement[]{new RequirementImpl("system.builder.msbuild." + label, true, ".*")});
    }

    @NotNull
    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job buildable) {
        String label = (String)taskDefinition.getConfiguration().get("label");
        return Sets.newHashSet((Object[])new Requirement[]{new RequirementImpl("system.builder.msbuild." + label, true, ".*")});
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @NotNull ErrorCollection errorCollection) {
        String label;
        String solution = actionParametersMap.getString("solution");
        if (StringUtils.isEmpty((CharSequence)solution)) {
            errorCollection.addError("solution", this.textProvider.getText("msbuild.solution.error"));
        }
        if (StringUtils.isEmpty((CharSequence)(label = actionParametersMap.getString("label")))) {
            errorCollection.addError("label", this.textProvider.getText("msbuild.label.error"));
        }
    }

    @Override
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("solution", DEFAULT_SOLUTION);
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.taskConfiguratorHelper.populateContextWithConfiguration(context, taskDefinition, FIELDS_TO_COPY);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map map = super.generateTaskConfigMap(params, previousTaskDefinition);
        this.taskConfiguratorHelper.populateTaskConfigMapWithActionParameters(map, params, FIELDS_TO_COPY);
        return map;
    }
}

