define('branchinator/views/layout/header-view', [
    'branchinator/views/layout/header/branch-selection-view',
    'jquery',
    'marionette'
], function(
    BranchSelectionView,
    $,
    Marionette
) {
    'use strict';

    /**
     * View for displaying branch status page header.
     *
     * Parameters:
     * - model - branch selection model
     * - hasRepositories - whether there are global, branchable repositories defined for this Bamboo instance
     */
    return Marionette.LayoutView.extend({
        id: 'branchStatusHeader',
        tagName: 'header',
        className: 'aui-page-header',

        regions: {
            branchSelection: '#branchSelectionContainer'
        },

        template: function() {
            return bamboo.plugins.branchinator.renderHeaderView();
        },

        initialize: function(options) {
            this.options = options;
        },

        onShow: function() {
            if (this.getOption('hasRepositories')) {
                this.branchSelection.show(new BranchSelectionView({
                    model: this.model
                }));
            }
        }
    });
});
