define('branchinator/views/layout/content/integrations/pull-requests-table-row-view', [
    'marionette'
], function(
    Marionette
) {
    'use strict';

    /**
     * Data for sending analytics event when user clicks pull request link to navigate to pull request details.
     */
    var pullRequestDetailsAnalyticsData = JSON.stringify({
        name: 'branch.view.action.pullRequest.details.clicked'
    });

    /**
     * A single row of pull requests table. Represents a single pull request for currently selected branch.
     */
    return Marionette.ItemView.extend({
        tagName: 'tr',

        modelEvents: {
            'change': 'render'
        },

        template: function(data) {
            return bamboo.plugins.branchinator.renderPullRequestTableRowView({
                pullRequest: data,
                pullRequestDetailsAnalyticsData: pullRequestDetailsAnalyticsData
            });
        }
    });
});
