define('branchinator/views/layout/content/integrations-view', [
    'branchinator/collections/pull-requests-collection',
    'branchinator/views/layout/content/integrations/pull-requests-table-view',
    'marionette'
], function(
    PullRequestsCollection,
    PullRequestsTableView,
    Marionette
) {
    'use strict';

    /**
     * View for displaying additional integrations on Branch Status page.
     *
     * Parameters:
     * - model - branch selection model
     */
    return Marionette.LayoutView.extend({
        regions: {
            pullRequests: '#pullRequestsContainer'
        },

        template: function() {
            return bamboo.plugins.branchinator.renderIntegrationsView();
        },

        onShow: function() {
            this.pullRequests.show(new PullRequestsTableView({
                model: this.model,
                collection: PullRequestsCollection.forRepositoryBranch(
                    this.model.getRepoId(),
                    this.model.getBranchName()
                )
            }));
        }
    });
});
